 /**
 * @file    network_stubs.h
 * @brief   mbed Endpoint Network Stubs header (6LowPAN)
 * @author  Doug Anson
 * @version 1.0
 * @see     
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
 #ifndef __MESH_STUBS_H__
 #define __MESH_STUBS_H__
 
 // mbed support
 #include "mbed.h"
 
 // we have to redefine DBG as its used differently here...
 #ifdef DBG
    #undef DBG
 #endif
 #define DBG  printf
 
 // Nanostack_6LowPAN support...
 #include "configuration.h"
 #include "debug.h"
 #include "ns_6lowpan_support.h"
 #include "nsdl_support.h"
 
 // tasklet function typedef
 typedef void (*mbed_tasklet_main_fn)(void);
  
 // ties into Nanostack_6LowPAN network support
 extern "C" void event_dispatch(void);
 extern void init_network(bool canActAsRouterNode);
 
 #endif // __MESH_STUBS_H__