/**
 * @file    DeviceStringResource.h
 * @brief   mbed CoAP Endpoint Device String Resource
 * @author  Doug Anson
 * @version 1.0
 * @see
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __DEVICE_STRING_RESOURCE_H__
#define __DEVICE_STRING_RESOURCE_H__

// Base class
#include "mbed-connector-interface/DynamicResource.h"

// Device Management Responder 
#include "mbed-connector-interface/DeviceManagementResponder.h"

/** DeviceStringResource class
 */
class DeviceStringResource : public DynamicResource
{
public:
    /**
    Default constructor
    @param logger input logger instance for this resource
    @param obj_name input the String Object ID
    @param res_name input the String Resource ID
    @param res_type input the String Resource Type
    @param dm_responder input the DM responder instance
    @param observable input this String is observable
    */
    DeviceStringResource(const Logger *logger,const char *obj_name,const char *res_name,const char *res_type,const void *dm_responder,bool observable = false) : 
        DynamicResource(logger,obj_name,res_name,res_type,M2MBase::GET_PUT_ALLOWED,observable)
    {
        this->m_dm_responder = (DeviceManagementResponder *)dm_responder;
        this->m_implements_observation = true; // PUT() sends observation...
    }

    /**
    GET handler
    @returns string with this resource type
    */
    virtual string get() {
        return this->m_value;
    }
    
    /**
    PUT handler
    @param value input input value
    */
    virtual void put(string value) {
        this->m_value = value;
        this->observe();
    }

protected:
    DeviceManagementResponder     *m_dm_responder;
    
private:
    string                         m_value; 
};

#endif // __DEVICE_STRING_RESOURCE_H__
