/**
 * @file    DeviceFirmwareCompositeResource.h
 * @brief   mbed CoAP Endpoint Device Firmware Composited Resource
 * @author  Doug Anson
 * @version 1.0
 * @see
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __DEVICE_FIRMWARE_COMPOSITE_RESOURCE_H__
#define __DEVICE_FIRMWARE_COMPOSITE_RESOURCE_H__

// Dynamic Resource Support
#include "mbed-connector-interface/DynamicResource.h"

// LWM2M Device Firmware Package Resource ID
#define LWM2M_DEV_FIRMWARE_PACKAGE_ID       "0"

// LWM2M Device Firmware Package Resource ID
#define LWM2M_DEV_FIRMWARE_PACKAGE_URI_ID   "1"

// LWM2M Device Firmware Update Resource ID
#define LWM2M_DEV_FIRMWARE_UPDATE_ID        "2"

// LWM2M Device Firmware State Resource ID
#define LWM2M_DEV_FIRMWARE_STATE_ID         "3"

// LWM2M Device Firmware Result Resource ID
#define LWM2M_DEV_FIRMWARE_RESULT_ID        "5"

// LWM2M Device Firmware Package Name Resource ID
#define LWM2M_DEV_FIRMWARE_PKG_NAME_ID      "6"

// LWM2M Device Firmware Package Version Resource ID
#define LWM2M_DEV_FIRMWARE_PKG_VERSION_ID   "7"

// LWM2M: Firmware Resource IDs
typedef enum {
        LWM2M_PAYLOAD_ID = 0,                    // /5/0/0 - Direct Firmware Payload
        LWM2M_MANIFEST_ID = 1,                   // /5/0/1 - Firmware Payload URL
        LWM2M_UPDATE_ID = 2,                     // /5/0/2 - FOTA Update 
        LWM2M_STATE_ID = 3,                      // /5/0/3 - State
        LWM2M_RESULT_ID = 5,                     // /5/0/4 - Result
        LWM2M_PKGNAME_ID = 6,                    // /5/0/6 - PkgName
        LWM2M_PKGVERSION_ID = 7,                 // /5/0/7 - PkgVersion
        NUM_FIRMWARE_RESOURCE_IDS = 8            // max number of Firmware resources
} FirmwareResourceIDs;    
        
/** DeviceFirmwareCompositeResource class
 */
class DeviceFirmwareCompositeResource
{
public:
    /**
    Default constructor
    @param logger input logger instance for this resource
    @param obj_name input the Light Object name
    @param dm_responder input the DM responder instance
    */
    DeviceFirmwareCompositeResource(const Logger *logger,const char *obj_name,const void *dm_responder);
    
    /** 
    Copy Constructor
    @param res input DeviceFirmwareCompositeResource instance to shallow copy
    */
    DeviceFirmwareCompositeResource(const DeviceFirmwareCompositeResource &res);
    
    // Destructor
    virtual ~DeviceFirmwareCompositeResource();
    
    // Build Internal Resources
    void buildResources();
    
    /** 
    Add Resources
    @param cfg input pointer to Connector::OptionsBuilder configuration instance for our endpoint
    */
    void addResources(void *cfg);
    
    /**
    Get Resource
    @param index input the resource ID of the firmware resource to retrieve
    */
    void *getResource(FirmwareResourceIDs id);
    
private:
    Logger          *m_logger;
    void            *m_dm_responder; 
    char            *m_obj_name;
    DynamicResource *m_firmware_resource[NUM_FIRMWARE_RESOURCE_IDS];
    
};

#endif // __DEVICE_FIRMWARE_COMPOSITE_RESOURCE_H__