/**
 * @file    DeviceIntegerResource.h
 * @brief   mbed CoAP Endpoint Device Integer Resource
 * @author  Doug Anson
 * @version 1.0
 * @see
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __DEVICE_INTEGER_RESOURCE_H__
#define __DEVICE_INTEGER_RESOURCE_H__

// Base class
#include "mbed-connector-interface/DynamicResource.h"

// Device Management Responder 
#include "mbed-connector-interface/DeviceManagementResponder.h"

/** DeviceIntegerResource class
 */
class DeviceIntegerResource : public DynamicResource
{
public:
    /**
    Default constructor
    @param logger input logger instance for this resource
    @param obj_name input the Integer Object ID
    @param res_name input the Integer Resource ID
    @param res_type input the Integer Resource Type
    @param dm_responder input the DM responder instance
    @param observable input this Integer is observable
    */
    DeviceIntegerResource(const Logger *logger,const char *obj_name,const char *res_name,const char *res_type,const void *dm_responder,bool observable = false) : 
        DynamicResource(logger,obj_name,res_name,res_type,M2MBase::GET_PUT_ALLOWED,observable)
    {
        this->m_dm_responder = (DeviceManagementResponder *)dm_responder;
        this->m_implements_observation = true; // PUT() sends observation...
    }

    /**
    GET handler
    @returns string with this resource type
    */
    virtual string get() {
        char buf[10];
        memset(buf,0,10);
        sprintf(buf,"%d",this->m_value);
        return string(buf);
    }
    
    /**
    PUT handler
    @param value input input value
    */
    virtual void put(string value) {
        sscanf(value.c_str(),"%d",&this->m_value);
        this->observe();
    }

protected:
    DeviceManagementResponder     *m_dm_responder;
        
private:
    int                            m_value; 
};

#endif // __DEVICE_INTEGER_RESOURCE_H__
