/**
 * @file    DeviceFirmwareUpdateResource.h
 * @brief   mbed CoAP Endpoint Device Firmware Update Resource
 * @author  Doug Anson
 * @version 1.0
 * @see
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __DEVICE_REBOOT_RESOURCE_H__
#define __DEVICE_REBOOT_RESOURCE_H__

// Base class
#include "mbed-connector-interface/DeviceActionResource.h"

/** DeviceFirmwareUpdateResource class
 */
class DeviceFirmwareUpdateResource : public DeviceActionResource
{
public:
    /**
    Default constructor
    @param logger input logger instance for this resource
    @param obj_name input the Light Object name
    @param res_name input the Light Resource name
    @param dm_responder input the DM responder instance
    */
    DeviceFirmwareUpdateResource(const Logger *logger,const char *obj_name,const char *res_name,const void *dm_responder,bool observable=false) : 
        DeviceActionResource(logger,obj_name,res_name,"fw_update",dm_responder,observable)
    {
    }
    
    /**
    do_action()
    @param value input input value (DM authentication challenge)
    */
    virtual bool do_action(void *args) {
        // reboot the device. Input value should the DM authentication challenge)
        this->m_dm_responder->invokeFOTA(args);
        return true;
    }
};

#endif // __DEVICE_REBOOT_RESOURCE_H__
