/**
 * @file    DeviceActionResource.h
 * @brief   mbed CoAP Endpoint Device Action Resource
 * @author  Doug Anson
 * @version 1.0
 * @see
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __DEVICE_ACTION_RESOURCE_H__
#define __DEVICE_ACTION_RESOURCE_H__

// Base class
#include "mbed-connector-interface/DynamicResource.h"

// Device Management Responder 
#include "mbed-connector-interface/DeviceManagementResponder.h"

/** DeviceActionResource class
 */
class DeviceActionResource : public DynamicResource
{
public:
    /**
    Default constructor
    @param logger input logger instance for this resource
    @param obj_name input the Action Object ID
    @param res_name input the Action Resource ID
    @param res_type input the Action Resource Type
    @param dm_responder input the DM responder instance
    @param observable input this Action is observable
    */
    DeviceActionResource(const Logger *logger,const char *obj_name,const char *res_name,const char *res_type,const void *dm_responder,bool observable = false) : 
        DynamicResource(logger,obj_name,res_name,res_type,M2MBase::GET_POST_ALLOWED,observable)
    {
        this->m_dm_responder = (DeviceManagementResponder *)dm_responder;
        this->m_value = string("OK");
    }

    /**
    GET handler
    @returns string with this resource type
    */
    virtual string get() {
        return this->m_value;
    }
    
    /**
    POST handler
    @param value input input value (DM authentication challenge)
    */
    virtual void post(void *args) {
        // perform our action
        bool status = this->do_action(args);
        if (status == true) {
            this->m_value = string("OK");
        }
        else {
            this->m_value = string("FAIL");
        }
    }
    
    // Our actual action handler
    virtual bool do_action(void *args) = 0;  //  pure. Derive and implement, then add additional call to DeviceManagementResponder...

protected:
    DeviceManagementResponder     *m_dm_responder;
        
private:
    string                         m_value; 
};

#endif // __DEVICE_ACTION_RESOURCE_H__
