/**
 * @file    LocationResource.h
 * @brief   mbed CoAP Endpoint Location resource supporting CoAP GET
 * @author  Doug Anson
 * @version 1.0
 * @see
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __LOCATION_RESOURCE_H__
#define __LOCATION_RESOURCE_H__

// Base class
#include "DynamicResource.h"

// our Location source
#include "MBEDUbloxGPS.h"
extern RawSerial pc;             // main.cpp
MBEDUbloxGPS _ublox_gps(&pc);    // U-blox GPS support

// Maximum Location JSON Length : {"latitude":XXX.YYYYYY, "longitude":XXX.YYYYYY, "msl":XXXXXX, "speed":XXXXXX}
#define LOCATION_JSON_LENGTH  96

/** LocationResource class
 */
class LocationResource : public DynamicResource
{
public:
    /**
    Default constructor
    @param logger input logger instance for this resource
    @param name input the Location resource name
    @param observable input the resource is Observable (default: FALSE)
    */
    LocationResource(const Logger *logger,const char *name,const bool observable = false) : DynamicResource(logger,name,"Location",SN_GRS_GET_ALLOWED,observable) {
    }

    /**
    Get the value of the Location sensor
    @returns string containing the temperature sensor value
    */
    virtual string get() {
        _ublox_gps.updateLocation();
        char json[LOCATION_JSON_LENGTH+1];
        memset(json,0,LOCATION_JSON_LENGTH+1);
        sprintf(json,"{\"latitude\":%s,\"longitude\":%s,\"msl\":%s,\"speed\":%s}",
                    _ublox_gps.getLatitude(),
                    _ublox_gps.getLongitude(),
                    _ublox_gps.getMSLAltitude(),
                    _ublox_gps.getSpeed());
        return string(json);
    }
};

#endif // __LOCATION_RESOURCE_H__