/**
 * @file    TemperatureResource.h
 * @brief   mbed CoAP Endpoint Temperature sensor resource supporting CoAP GET
 * @author  Doug Anson
 * @version 1.0
 * @see
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __TEMPERATURE_RESOURCE_H__
#define __TEMPERATURE_RESOURCE_H__

// Base class
#include "DynamicResource.h"

// our Temperature sensor
#include "LM75B.h"
LM75B temp_sensor(D14,D15);

/** TemperatureResource class
 */
class TemperatureResource : public DynamicResource
{
public:
    /**
    Default constructor
    @param logger input logger instance for this resource
    @param name input the Temperature resource name
    @param observable input the resource is Observable (default: FALSE)
    */
    TemperatureResource(const Logger *logger,const char *name,const bool observable = false) : DynamicResource(logger,name,"Temperature",SN_GRS_GET_ALLOWED,observable) {
    }

    /**
    Get the value of the Temperature sensor
    @returns string containing the temperature sensor value
    */
    virtual string get() {
        char temp[7];
        memset(temp,0,7);
        sprintf(temp,"%3.2f", temp_sensor.temp());
        return string(temp);
    }
};

#endif // __TEMPERATURE_RESOURCE_H__
