/* Copyright C2014 ARM, MIT License
 *
 * Author: Doug Anson (doug.anson@arm.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "mbed.h"

// Blinky
DigitalOut led(LED1);

// Our sensor as an InterruptIn
InterruptIn sensor(D0);

// Grove Earbud Sensor include
#include "GroveEarbudSensor.h"

// callback for receiving heartrate values
void heartrateCallback(float heartrate,void *data) {
    printf("Callback: heartrate = %.1f\r\n",heartrate);
}

int main()
{   
    // announce
    printf("Grove Earbud Sensor Example v1.0.0\r\n");
    
    // allocate the earbud sensor
    printf("Allocating earbud sensor instance...\r\n");
    GroveEarbudSensor earbud(&sensor); 
    
    // register our callback function
    printf("registering callback...\r\n");
    earbud.registerCallback(heartrateCallback);
    
    // begin main loop
    printf("Beginning main loop...\r\n");
    while (true) {
        // blink... 
        led = !led; 
        wait(0.5);
        
        // we can also call directly 
        //printf("Direct: heartrate = %.1f\r\n",earbud.getHeartRate());
    }
}