/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 // class support
 #include "NSPLightResourceFactory.h"
 
 #ifndef CELLULAR_NETWORK
    #include "EthernetInterface.h"
    extern EthernetInterface ethernet;
 #endif
 
 // MBED supports GPS location observation 
 #include "gps.h"
 
 // MBED supports RSSI observation 
 #include "rssi.h"
  
 // MBED supports Temperature Sensing 
 #include "temperature.h"
 
 // MBED supports Battery Emulation
 #include "battery.h"
 
 // MBED supports Voltage Emulation
 #include "voltage.h"
 
 // MBED supports Wattage Emulation
 #include "wattage.h"
 
 // MBED support Current Emulation
 #include "current.h"
 
 // MBED support Dimming Operations
 #include "dimmer.h"
 
 // MBED support Light Switch Operations
 #include "switch.h"
 
 // MBED support AddlData for IOC Integration
 #include "addldata.h"
 
 // MBED supports observable MDL text 
 #include "mdltext.h"
 
 // MBED supports observable MFG text
 #include "mfgtext.h"
 
 // MBED supports observable location text
 #include "locationtext.h"
 
 // MBEDEndpoint support
 #include "MBEDEndpoint.h"
 
 // default constructor
 NSPLightResourceFactory::NSPLightResourceFactory(Logger *logger,void *endpoint) : NSPResourceFactory(logger,endpoint) {
 }
 
 // default destructor
 NSPLightResourceFactory::~NSPLightResourceFactory() {
 }
 
 // create resources modeling a Light personality
 void NSPLightResourceFactory::createResources(char *ep_name) { 
    MBEDEndpoint *endpoint = (MBEDEndpoint *)this->getEndpoint();
    
    // record the endpoint name
    this->setEndpointName(ep_name);
    
    // initialize resource structures
    this->initResourceStructures();
           
    // create all of the resources we expect for this endpoint
    this->createResource(ep_name,"/dev/addldata","id:0",(void *)&addldata_cb,(sn_grs_resource_acl_e)(SN_GRS_GET_ALLOWED|SN_GRS_PUT_ALLOWED),(void *)&init_addldata,"core#s",(char *)NULL);
    this->createResource(ep_name,"/dev/location",ENDPOINT_LOCATION,(void *)&locationtext_cb,(sn_grs_resource_acl_e)SN_GRS_GET_ALLOWED,(void *)&init_locationtext,"core#s","ns:location");
    //this->createResource("/fw/devtype",NSP_NODE_TYPE,"core#s","ns:devtype");
    this->createResource(ep_name,"/dev/bat","5.0V",(void *)&battery_cb,(sn_grs_resource_acl_e)SN_GRS_GET_ALLOWED,(void *)&init_battery,(char *)NULL,"ipso:dev-bat");
    this->createResource(ep_name,"/sen/I","0.1",(void *)&current_cb,(sn_grs_resource_acl_e)SN_GRS_GET_ALLOWED,(void *)&init_current,(char *)NULL,"ucum:A");
    //this->createResource(ep_name,"/dev/I","0.1",(void *)&current_cb,(sn_grs_resource_acl_e)SN_GRS_GET_ALLOWED,(void *)&init_current,(char *)NULL,"ucum:A");
#ifndef CELLULAR_NETWORK
    this->createResource("/nw/ipaddr",ethernet.getIPAddress(),"core#s","ns:v4addr");
#else
    this->createResource("/nw/ipaddr","0.0.0.0","core#s","ns:v4addr");
#endif
    this->createResource(ep_name,"/lt/0/dim",LIGHT_DIM_STATE,(void *)&dimmer_cb,(sn_grs_resource_acl_e)(SN_GRS_GET_ALLOWED|SN_GRS_PUT_ALLOWED),(void *)&init_dimmer,(char *)NULL,"ipso:lt-dim");    // Action: dim/brighten light
    //this->createResource("/nw/eripaddr","N/A","core#s","ns:v4addr");
    this->createResource(ep_name,"/lt/0/on",LIGHT_DEFAULT_STATE,(void *)&switch_cb,(sn_grs_resource_acl_e)(SN_GRS_GET_ALLOWED|SN_GRS_PUT_ALLOWED),(void *)&init_switch,(char *)NULL,"ipso:lt-on");       // Action: light on/off
    //this->createResource(ep_name,"/lt/0/ctr",LIGHT_DEFAULT_STATE,(void *)&switch_cb,(sn_grs_resource_acl_e)(SN_GRS_GET_ALLOWED|SN_GRS_PUT_ALLOWED),(void *)&init_switch,(char *)NULL,"ns:boolean");       // Action: light on/off
    this->createResource(ep_name,"/dev/mdl",NSP_ENDPOINT_TYPE,(void *)&mdltext_cb,(sn_grs_resource_acl_e)SN_GRS_GET_ALLOWED,(void *)&init_mdltext,"core#s","ipso:dev-mdl");
    this->createResource(ep_name,"/dev/mfg",PLATFORM_STRING,(void *)&mfgtext_cb,(sn_grs_resource_acl_e)SN_GRS_GET_ALLOWED,(void *)&init_mfgtext,"core#s","ipso:dev-mfg");
    this->createResource("/gps/int","60","core#s","ns:counter");
    this->createResource("/gps/fix","1","core#s","ns:boolean");
    //this->createResource("/nw/pipaddr","N/A","core#s","ns:v4addr");
    //this->createResource(ep_name,"/nw/prssi","-75",(void *)&rssi_cb,(sn_grs_resource_acl_e)SN_GRS_GET_ALLOWED,(void *)&init_rssi,"core#s","ns:rssi");
    //this->createResource(ep_name,"/dev/W","0.1",(void *)&wattage_cb,(sn_grs_resource_acl_e)SN_GRS_GET_ALLOWED,(void *)&init_wattage,(char *)NULL,"ucum:W");
    this->createResource(ep_name,"/sen/temp","10.0",(void *)&temp_cb,(sn_grs_resource_acl_e)(SN_GRS_GET_ALLOWED|SN_GRS_PUT_ALLOWED),(void *)&init_temp,(char *)NULL,"ucum:Cel");
    //this->createResource(ep_name,"/dev/t","10.0",(void *)&temp_cb,(sn_grs_resource_acl_e)(SN_GRS_GET_ALLOWED|SN_GRS_PUT_ALLOWED),(void *)&init_temp,(char *)NULL,"ucum:Cel");
    this->createResource(ep_name,"/sen/V","5.0",(void *)&voltage_cb,(sn_grs_resource_acl_e)SN_GRS_GET_ALLOWED,(void *)&init_voltage,(char *)NULL,"ucum:V");
    //this->createResource(ep_name,"/dev/V","5.0",(void *)&voltage_cb,(sn_grs_resource_acl_e)SN_GRS_GET_ALLOWED,(void *)&init_voltage,(char *)NULL,"ucum:V");
    this->createResource(ep_name,"/gps/loc",ENDPOINT_GPS_COORDS,(void *)&gps_location_cb,(sn_grs_resource_acl_e)SN_GRS_GET_ALLOWED,(void *)&init_gps,"core#s","ns:gpsloc");    
    this->createResource("/ns/nspaddr",endpoint->getNSPAddress(),"core#s","ns:v4addr");
    this->createResource(ep_name,"/dev/panic","0",(void *)&switch_cb,(sn_grs_resource_acl_e)(SN_GRS_GET_ALLOWED),(void *)&init_switch,"core#s","ns:panic");      

#ifdef MAC_ADDRESS
    extern char fmt_mac[RESOURCE_VALUE_LEN+1];
    this->createResource("/nw/macaddr",fmt_mac,"core#s","ns:euid64");
#else
    this->createResource("/nw/macaddr","00:00:00:00:00","core#s","ns:euid64");
#endif
        
    // finalize the registration
    this->finalizeRegistration();
 }