/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #ifndef _NSP_IO_H_
 #define _NSP_IO_H_

 // Base class support
 #include "MBEDio.h"
 
 // observation sender callback signature
 typedef void (*sn_send_observation_t)();
 
 class NSPio : public MBEDio {
     private:
        sn_send_observation_t  m_obs_sender;
        MBEDio                *m_mbed_io;
        
     public:
        NSPio(Logger *logger,Resource *resource,sn_send_observation_t obs_sender);
        NSPio(MBEDio *mbed_io,sn_send_observation_t obs_sender);
        virtual ~NSPio();
        
        float floatValue();
        int   intValue();
        char *stringValue();
        
        virtual void update();
        
        void sendObservation();
 };
 
 #endif // _NSP_IO_H_