/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "NSPTransport.h"
 
 #ifndef CELLULAR_NETWORK
    #include "EthernetInterface.h"
 #endif
  
 // NSP Support
 #include "nsdl_support.h"
 
 // Endpoint support
 #include "MBEDEndpoint.h"
 
 // default constructor
 NSPTransport::NSPTransport(Logger *logger,void *endpoint) : Transport(logger,endpoint) {
      this->initNSP();
 }
 
 // default destructor
 NSPTransport::~NSPTransport() {
     this->disconnect();
 }
 
 // Initialize NSP
 void NSPTransport::initNSP() {
    server.init();
 }
 
 // check transport and process stuff
 void NSPTransport::checkAndProcess() {
     // Run the NSDL event loop (never returns)
    nsdl_event_loop();
 }
 
 // connect up NSP
 bool NSPTransport::connect() { 
     if (!this->m_connected) { 
        // get our endpoint
        MBEDEndpoint *endpoint = (MBEDEndpoint *)this->logger()->getEndpoint();   

        // bind to the NSP
        server.bind(endpoint->getNSPPort());
        nsp.set_address((char *)endpoint->getNSPAddress(),(int)endpoint->getNSPPort());
        
        // DEBUG
        this->logger()->log("Connecting... NSP: %s:%d",endpoint->getNSPAddress(),endpoint->getNSPPort());  
        
        // Initialize NSDL stack
        nsdl_init();
        
        // we are connected
        this->m_connected = true;
    }
    
    // return the connection status
    return this->m_connected; 
 }
 
 // disconnect from NSP
 bool NSPTransport::disconnect() { return true; }