/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef _NSP_RESOURCE_H
#define _NSP_RESOURCE_H

// base class
#include "Resource.h"

// NSDL Library Support
#include "nsdl_support.h"

class NSPResource : public Resource {
    private:
        void                  *m_resource_ptr;
        char                   m_nsp_name[RESOURCE_NAME_LEN+1];
        char                  *m_interface;
        int                    m_interface_len;
        char                  *m_resource;
        int                    m_resource_len;
        int                    m_observable;
        int                    m_registered;
        sn_grs_resource_acl_e  m_acl;
        
    public:
        NSPResource(Logger *logger,char *ep_name,char *name,char *value,void *cb,void *cb_ptr,sn_grs_resource_acl_e acl,char *interface, char *resource);
        virtual ~NSPResource();
                        
        virtual void plumb(char *endpoint_name,char *name);
        virtual void extract(char *name);  
        
        void sendObservation();    
};

#endif // _NSP_RESOURCE_H