/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "NSPio.h"
 
 // default constructor
 NSPio::NSPio(Logger *logger,Resource *resource,sn_send_observation_t obs_sender) : MBEDio(logger,resource) {
     this->m_obs_sender = obs_sender;
     this->m_mbed_io = NULL;
 }
 
 // wrapping a generic MBEDio within a NSPio so that we can do things like NSP observation...
 NSPio::NSPio(MBEDio *mbed_io,sn_send_observation_t obs_sender) : MBEDio(mbed_io->logger(),mbed_io->resource()) {
     this->m_obs_sender = obs_sender;
     this->m_mbed_io = mbed_io;
     if (this->m_mbed_io != NULL && this->m_mbed_io->resource() != NULL) this->m_mbed_io->resource()->setIO(this);
 }
 
 // destructor
 NSPio::~NSPio() {
 }
 
 // send an observation
 void NSPio::sendObservation() { if (this->m_obs_sender != NULL) (this->m_obs_sender)(); }
 
 // update
 void NSPio::update() { if (this->m_mbed_io != NULL) this->m_mbed_io->update(); }
 
 // get the float value (refreshes the value)
 float NSPio::floatValue() { 
    if (this->m_mbed_io != NULL) return this->m_mbed_io->floatValue();
    return MBEDio::floatValue();
 }
 
 // get the int value (refreshes the value)
 int NSPio::intValue() { 
    if (this->m_mbed_io != NULL) return this->m_mbed_io->intValue();
    return MBEDio::intValue(); 
 }
 
 // get the string value (refreshes the value)
 char *NSPio::stringValue() { 
    if (this->m_mbed_io != NULL) return this->m_mbed_io->stringValue();
    return MBEDio::stringValue();
 }