/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef _NSP_RESOURCE_FACTORY_H_
#define _NSP_RESOURCE_FACTORY_H_

// Base Class
#include "ResourceFactory.h"

// Logger support
#include "Logger.h"

// NSDL library support
#include "nsdl_support.h"

// Resource Initializar callback structure
typedef void (*resourceInitializer)(Resource *);

class NSPResourceFactory : public ResourceFactory {   
    private:
        char m_endpoint_name[PERSONALITY_NAME_LEN+1];
        void *m_resource_ptr;
          
    public:
        NSPResourceFactory(Logger *logger,void *endpoint);
        virtual ~NSPResourceFactory();
                      
        virtual void createResources(char *endpoint_name) = 0;
        
        void sendObservations();
    
    protected:
        virtual void createResource(char *name,char *value);
        virtual void createResource(char *name,char *value, char *interface, char *resource);
        virtual void createResource(char *endpoint_name,char *name,char *value,void *cb);
        virtual void createResource(char *endpoint_name,char *name,char *value,void *cb, char *interface, char *resource);
        void createResource(char *endpoint_name,char *name,char *value,void *cb,sn_grs_resource_acl_e acl);
        void createResource(char *endpoint_name,char *name,char *value,void *cb,sn_grs_resource_acl_e acl, char *interface, char *resource);
        void createResource(char *endpoint_name,char *name,char *value,void *cb,sn_grs_resource_acl_e acl,void *io);
        void createResource(char *endpoint_name,char *name,char *value,void *cb,sn_grs_resource_acl_e acl,void *io, char *interface, char *resource);
        void setEndpointName(char *endpoint_name);
        char *getEndpointName();
        void finalizeRegistration();
        void initResourceStructures();
        void freeResourceStructures();
};


#endif // _NSP_RESOURCE_FACTORY_H_