/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "NSPResource.h"
 
 // NSP Support Includes
 #include "nsdl_support.h"
 
 // NSP io support for sending observations
 #include "NSPio.h"
 
 // default constructor
 NSPResource::NSPResource(Logger *logger,char *ep_name,char *name,char *value,void *cb,void *resource_ptr,sn_grs_resource_acl_e acl,char *interface, char *resource) : Resource(logger,ep_name,name,value,cb)  {
     this->m_resource_ptr = resource_ptr;
     this->m_acl = acl;
     this->m_interface = interface;
     this->m_interface_len = 0;
     if (interface != NULL) this->m_interface_len = strlen(interface); 
     this->m_resource = resource;
     this->m_resource_len = 0;
     this->m_observable = NSP_RESOURCES_OBSERVABLE;
     this->m_registered = NSP_RESOURCES_REGISTERED;
     if (resource != NULL) this->m_resource_len = strlen(resource);
     memset(this->m_nsp_name,0,RESOURCE_NAME_LEN+1);
     strcpy(this->m_nsp_name,(char *)(name+1));            // omit the leading "/"
     this->plumb(ep_name,this->m_nsp_name);
 }
  
 // default destructor
 NSPResource::~NSPResource() {   
 }
 
 // send observation
 void NSPResource::sendObservation() {
     if (this->getCallbackPointer() != NULL) {
         // its a dynamic resource - so cast
         NSPio *io = (NSPio *)(this->getIO());
         if (io != NULL) io->sendObservation();
     }
 }
  
 // plumb the resource within NSP
 void NSPResource::plumb(char *ep_name,char *name) {          
     // DEBUG
     //this->logger()->log("NSP: Plumbing Resource - Endpoint: %s Resource: %s",ep_name,name);     
          
     // create the resource
     if (this->m_resource_ptr != NULL) {
         if (this->getCallbackPointer() == NULL) {
             // create a static resource
             nsdl_create_static_resource((sn_nsdl_resource_info_s *)this->m_resource_ptr,strlen(name),(uint8_t*)name, this->m_resource_len,(uint8_t *)this->m_resource,this->m_interface_len,(uint8_t *)this->m_interface,this->m_observable,this->m_registered,(uint8_t*)this->getValuePointer(),strlen(this->getValuePointer()));
         }
         else {
             // create a dynamic resource
             nsdl_create_dynamic_resource((sn_nsdl_resource_info_s *)this->m_resource_ptr,strlen(name),(uint8_t*)name,this->m_resource_len,(uint8_t *)this->m_resource,this->m_interface_len,(uint8_t *)this->m_interface,this->m_observable,this->m_registered,(sn_grs_dyn_res_callback_t)this->getCallbackPointer(),this->m_acl); 
         }
     }
     else {
         this->logger()->log("NSP: Unable to plumb Endpoint: %s Resource: %s - m_resource_ptr is NULL",ep_name,name);
     }
 }
 
 // extract the resource from NSP
 void NSPResource::extract(char *name) {  Resource::extract(name); }