/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef _NSP_DEFINITIONS_H_
#define _NSP_DEFINITIONS_H_

// Our Endpoint Version Annoucement
#define ENDPOINT_VERSION_ANNOUNCE   "\r\nMBED NSP Endpoint v1.0"

// NSP Configuration
#define NSP_ADDRESS                 "192.168.1.220"      // Target NSP Service - (default)
#define NSP_PORT                    5683                 // Target NSP Service Port Number

// Enable/Disable NSP Get and GetPut operations
#define NSP_ENABLE_GET              true                 // true - enable, false - disable
#define NSP_ENABLE_GETPUT           true                 // true - enable, false - disable

// Preference File Configuration
#define PREFERENCES_FILE            "/local/nsp.cfg"     // preferences file for endpoint 

// Gateway REST API URL
#define GW_AUTOREGISTER_URL         "http://%s:%s/NSP-IOC-Gateway/IOCRestAPI?ep=%s"

// Auto Register buffer sizes
#define AUTOREGISTER_URL_LENGTH     128
#define AUTOREGISTER_RESPONSE_LEN   128
#define GW_AUTOREGISTER_TIMEOUT_MS  2500

// Personality Name Configuration
#ifdef LIGHT_PERSONALITY
    #define PERSONALITY_NAME        "light-nsp-%d"        // name of each personality (i.e. light) in this endpoint
    #define NSP_NODE_TYPE           LIGHT_TYPE_STRING     // Node type
    #define PERSONALITY_TYPE        LIGHT_TYPE_STRING     // type of personality
    #define NSP_ENDPOINT_TYPE       "MBED NSP Light Node" // mfg type
#endif
#ifdef COPCAR_PERSONALITY
    #define PERSONALITY_NAME        "copcar-nsp-%d"       // name of each personality (i.e. copcar) in this endpoint
    #define NSP_NODE_TYPE           "CopCar"              // Node type
    #define PERSONALITY_TYPE        "Cop Car"             // type of personality
    #define NSP_ENDPOINT_TYPE       "MBED NSP Cop Car"    // mfg type
#endif

// NSP Configuration
#define NSP_NODE_LIFETIME            "9999"               // Node lifetime (seconds) - 25 minutes
#define RD_UPDATE_PERIOD             600                  // The number of seconds between NSP (re)registration messages - 10 minutes

// NSP Registration Configuration
#define NSP_RESOURCES_OBSERVABLE     1                    // 1 - all resources will be registered as observable, 0 - not observable
#define NSP_RESOURCES_REGISTERED     1                    // 1 - all resources will be registered, 0 - not registered

// Transport Configuration
#define NUM_TRANSPORTS               2                    // Transports used
#define NSP_TRANSPORT                0                    // NSP Transport index
#define HTTP_TRANSPORT               1                    // HTTP Transport index

#endif // _NSP_DEFINITIONS_H_