/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef _MQTT_DEFINITIONS_H_
#define _MQTT_DEFINITIONS_H_

// Our Endpoint Version Annoucement
#define ENDPOINT_VERSION_ANNOUNCE   "\r\nMBED MQTT Endpoint v1.0"

// Until we get HTTPS with BasicAuth working in MBED...
#define USE_GW_HTTP_REDIRECTOR      true                            // true - make http calls to IOC via GW, false - make http calls directly to IOC

// Gateway REST API URL
#define GW_REDIRECT_URL             "http://%s:%s/NSP-IOC-Gateway/IOCRestAPI"

// Preference File Configuration
#define PREFERENCES_FILE            "/local/mqtt.cfg"               // preferences file for endpoint  

// Personality Name Configuration
#ifdef LIGHT_PERSONALITY
    #define PERSONALITY_NAME        "light-mqtt-%d"                 // name of each personality (i.e. light) in this endpoint
    #define PERSONALITY_TYPE        LIGHT_TYPE_STRING               // type of personality
    #define MQTT_ENDPOINT_TYPE      "MBED MQTT Light Node"          // mfg type
#endif
#ifdef COPCAR_PERSONALITY
    #define PERSONALITY_NAME        "copcar-mqtt-%d"                // name of each personality (i.e. copcar) in this endpoint
    #define PERSONALITY_TYPE        "Cop Car"                       // type of personality
    #define MQTT_ENDPOINT_TYPE      "MBED MQTT Cop Car"             // mfg type
#endif

// Keyword Definitions for MQTT packets
#define IOC_REQUEST_LOAD_ALL_VERB   "load"
#define IOC_REQUEST_UPDATE_ALL_VERB "update"
#define IOC_ENDPOINT_VERB           "Endpoint"
#define IOC_ENDPOINT_ALL_VERB       "all"
#define IOC_CHANGE_VERB             "Change"
#define IOC_REQUEST_VALUE_VERB      "Get"
#define IOC_RESPONSE_VERB           "response"
#define IOC_REPONSE_ID_KEY          "id"
#define IOC_DATASOURCE_ID           "386"

// remap the IOC Datasource ID if we are a copcar
#ifdef COPCAR_PERSONALITY
  #undef IOC_DATASOURCE_ID
  #define IOC_DATASOURCE_ID           "388"
#endif

// IOC REST Buffer Lengths
#define IOC_REST_URL_LEN            128
#define IOC_RESULT_LEN              1024
#define IOC_PAYLOAD_LEN             768
#define IOC_IOC_ID_LEN              16

// IOC REST URL for Load/Updates
#define IOC_HOST_NAME               "iocweb.bcu.ac.uk"              // IOC Web - iocweb.bcu.ac.uk
#define IOC_REST_URL                "https://%s/ibm/ioc/api/data-injection-service/datablocks/%s/dataitems%s"
#define IOC_RESPONSE_TEMPLATE       "%s:{ENDPOINT=%s RESOURCE=%s VALUE=%s}:%s"
#define IOC_RESPONSE_OK             "OK"
#define IOC_RESPONSE_FAILED         "FAILED"

// Transport Configuration
#define NUM_TRANSPORTS              2                               // MQTT, HTTP
#define MQTT_TRANSPORT              0                               // MQTT Transport index
#define HTTP_TRANSPORT              1                               // HTTP Transport index

// Index for Transport to use for Update/Load
#define LOAD_TRANSPORT              1                               // 0 - MQTT, 1 - HTTP

// largest MQTT message that PubSubClient will send
#define MAX_MQTT_MESSAGE_LENGTH     128

// MQTT connect information
#define MQTT_HOSTNAME               "iocana.bcu.ac.uk"              // IOC MQTT Broker Host - iocana.bcu.ac.uk
#define MQTT_HOSTPORT               1883                            // IOC MQTT Broker Port
#define MQTT_ENDPOINT_ID            "mbed%d%d"                      // IOC MQTT Endpoint ID template
#define MQTT_MAXID_VALUE            99                              // IOC MQTT Endpoint ID maximum integer value
#define MQTT_ENDPOINT_IDLEN         20                              // IOC MQTT Endpoint ID length (max)
#define MQTT_IOC_TOPIC              "ARM/sensinode/control/%s"      // IOC MQTT Topic 
#define MQTT_IOC_ALL_TOPIC          "ARM/sensinode/control/all"     // IOC MQTT Topic (broadcast)
#define MQTT_PING_SEND_TOPIC        "ARM/sensinode/ping"            // IOC MQTT Ping Send Topic
#define MQTT_IOC_ALL_ENDPOINT       "all"                           // must be the same as the last element of MATT_IOC_ANNOUNCE_TOPIC
#define MQTT_IOC_TOPIC_LEN          64                              // max length for the topic string
#define MQTT_PAYLOAD_SEGMENT_LEN    64                              // max length for a segment of the payload
#define MQTT_USERNAME               ""                              // IOC MQTT Username
#define MQTT_PASSWORD               ""                              // IOC MQTT Password
#define MQTT_PING_VERB_LEN          10                              // Ping or Pong
#define MQTT_PING_COUNTDOWN         3600                            // Send ping to GW every 3600'th 250ms iteration (approx 15 minutes)
#define MQTT_MAX_COUNTER            32768                           // largest Ping counter before reset back to 1

#endif // _MQTT_DEFINITIONS_H_