/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef _MBED_ENDPOINT_H_
#define _MBED_ENDPOINT_H_

// BaseClass support
#include "BaseClass.h"

// MBED to IOC Resource Map
#include "MBEDToIOCResourceMap.h"

// Transport support
#include "MQTTTransport.h"
#include "IOCHTTPTransport.h"

// IOC Endpoint support
#include "IOCEndpoint.h"

// Personality Support
#include "Personality.h"

// ResourceFactory Support
#include "ResourceFactory.h"

// Preferences Support
#include "Preferences.h"

// network selection
#ifdef CELLULAR_NETWORK
    // Cellular
    #include "MBEDUbloxCellRadio.h"
    #include "MBEDUbloxGPS.h"
#else
    // Ethernet
    #include "EthernetInterface.h"
#endif
  
class MBEDEndpoint : public BaseClass {
    private:
#ifdef CELLULAR_NETWORK
        MBEDUbloxCellRadio   *m_cellular_modem;                            // cell modem
        MBEDUbloxGPS         *m_gps;                                       // GPS receiver
#else
        EthernetInterface    *m_ethernet;                                  // ethernet interface
#endif
        Transport            *m_transports[NUM_TRANSPORTS];                // our transport
        Personality          *m_personalities[NUM_PERSONALITY_INSTANCES];  // our personality instances (at least 1)
        char                  m_endpoint_name[PERSONALITY_NAME_LEN+1];     // our endpoint name (personality[0])
        MBEDToIOCResourceMap *m_map;                                       // IOC <--> MBED resource mapping
        Preferences          *m_preferences;                               // preference support
        char                  m_lcd_status[TEMP_BUFFER_LEN+1];             // LCD status buffer
        char                  m_gw_address[PREFERENCE_VALUE_LEN+1];        // GW address buffer
        char                  m_gw_port[PREFERENCE_VALUE_LEN+1];           // GW port buffer
        int                   m_instance_id;                               // instance ID for this endpoint
        void                 *m_status_reporter;                           // status reporter (optional)
         
    public:
        MBEDEndpoint(Logger *logger,void *transport,void *status_reporter,void *extra);
        virtual ~MBEDEndpoint();
        ResourceFactory *initResourceFactory();
        void run();
        
        int indexOfPersonality(char *name);
        ResourceFactory *getResources(int index);
        
        bool loadPersonalities();
        bool updatePersonalities();
        bool updatePersonality(int index);
        
        char *getEndpointName();
        char *getGWAddress();
        char *getGWPort();
        
        char *getLCDStatus();
        
        int getInstanceID();
                
        MBEDToIOCResourceMap *getMap();
    
        Preferences *preferences();
         
        void extraEventLoopWork();
        
    protected:
    
    private:
        bool initializePersonalities();
        bool closePersonalities();
        
        ResourceFactory *initLightResourceFactory();
        bool initializeLights();
        
        void initPreferences();
        void initGWAddress();
        void initEndpointName();
        bool initializeTransport(int index,char *key,Transport *transport);
        bool initializeTransports();
        bool loadPersonality(Personality *instance);
        bool updatePersonality(Personality *instance);
        bool closeTransport(int index,char *key);
        bool closeTransports();

#ifdef CELLULAR_NETWORK
        bool initializeCellularModem(void *modem);
        bool initializeGPSReceiver(void *gps);
        bool closeCellularModem();
        bool closeGPSReceiver();
#else
        bool initializeEthernet(EthernetInterface *ethernet);
        bool closeEthernet();
#endif 
};

#endif // _MBED_ENDPOINT_H_
