/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "IOCHTTPTransport.h"
 #include "MBEDEndpoint.h"
   
 // default constructor
 IOCHTTPTransport::IOCHTTPTransport(Logger *logger,void *endpoint) : HTTPTransport(logger,endpoint) {
     memset(this->m_url_buffer,0,IOC_REST_URL_LEN+1);
 }
 
 // default destructor
 IOCHTTPTransport::~IOCHTTPTransport() {
 }
 
 // package up data
 char *IOCHTTPTransport::packageData(char *verb,char *data,int ioc_id) {
     char buffer[IOC_PAYLOAD_LEN+1];
     memset(buffer,0,IOC_PAYLOAD_LEN+1);
     if (USE_GW_HTTP_REDIRECTOR == false) {
         // just use the data
         return data;
     }
     else {
         // repackage into format: VERB;USER;PASS;AUTHDOMAIN;CONTENTTYPE;JSON;URL
         sprintf(buffer,"%s;%s;%s;_none_;%s;%s;%s ",verb,IOC_USERNAME,IOC_PASSWORD,"application/json",data,this->createIOCUpdateURL(ioc_id,false));
         memcpy(data,buffer,strlen(buffer));
         return data;
     }
 }
 
 // Load up our endpoint into the IOC
 bool IOCHTTPTransport::loadEndpoint(char *data,int data_length,char *result,int result_length) {
    data = this->packageData("POST",data,0);    // must be first as it will first write into the common URL buffer
    char *url = this->createIOCLoadURL();       // resets the common URL buffer to point to the IOC GW 
    return this->httpPost(url,data,strlen(data),result,result_length); 
 }
 
 // update our endpoint with the IOC
 bool IOCHTTPTransport::updateEndpoint(int ioc_id,char *data,int data_length,char *result,int result_length) { 
    //this->logger()->log("updateEndpoint: %s",data);
    data = this->packageData("PUT",data,ioc_id);
    return this->httpPut(this->createIOCUpdateURL(ioc_id),data,strlen(data),result,result_length); 
 }
 
 // create the IOC load URL
 char *IOCHTTPTransport::createIOCLoadURL() { return this->createIOCUpdateURL(0); }
 
 // create the IOC update URL
 char *IOCHTTPTransport::createIOCUpdateURL(int ioc_id) { return this->createIOCUpdateURL(ioc_id,USE_GW_HTTP_REDIRECTOR); }
 char *IOCHTTPTransport::createIOCUpdateURL(int ioc_id,bool useRedirector) {
     if (useRedirector == false) {
         // make HTTP calls directly
         char ioc_id_str[IOC_IOC_ID_LEN+1];
         memset(ioc_id_str,0,IOC_IOC_ID_LEN+1);
         if (ioc_id > 0) sprintf(ioc_id_str,"/%d",ioc_id);
         memset(this->m_url_buffer,0,IOC_REST_URL_LEN+1);
         sprintf(this->m_url_buffer,IOC_REST_URL,IOC_HOST_NAME,IOC_DATASOURCE_ID,ioc_id_str);
     }
     else {
         // get our endpoint
         MBEDEndpoint *endpoint = (MBEDEndpoint *)this->getEndpoint();
         
         // use the GW HTTP redirector
         memset(this->m_url_buffer,0,IOC_REST_URL_LEN+1);
         sprintf(this->m_url_buffer,GW_REDIRECT_URL,endpoint->getGWAddress(),endpoint->getGWPort());
     }
     return this->m_url_buffer;
 }    
 
 // HTTP Get
 bool IOCHTTPTransport::httpGet(char *url,char *result,int result_length) {
    this->m_http->basicAuth(IOC_USERNAME,IOC_PASSWORD);
    return HTTPTransport::httpGet(url,result,result_length);
 }
 
 // HTTP Put
 bool IOCHTTPTransport::httpPut(char *url,char *data,int data_length,char *result,int result_length) {
     this->m_http->basicAuth(IOC_USERNAME,IOC_PASSWORD);
     //this->logger()->log("httpPut: URL: %s  DATA: %s",url,data);
     return HTTPTransport::httpPut(url,data,data_length,result,result_length);
 }
 
 // HTTP Post
 bool IOCHTTPTransport::httpPost(char *url,char *data,int data_length,char *result,int result_length) {
     this->m_http->basicAuth(IOC_USERNAME,IOC_PASSWORD);
     //this->logger()->log("httpPost: URL: %s  DATA: %s",url,data);
     return HTTPTransport::httpPost(url,data,data_length,result,result_length);
 }
 
 // HTTP Delete
  bool IOCHTTPTransport::httpDelete(char *url,char *data,int data_length) {
    this->m_http->basicAuth(IOC_USERNAME,IOC_PASSWORD);
    return HTTPTransport::httpDelete(url,data,data_length);
 }