/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef ___MQTTTRANSPORT_H_
#define ___MQTTTRANSPORT_H_

// Base Class
#include "Transport.h"

// MQTT Support
#include "PubSubClient.h"

// MBED to IOC Resource Map
#include "MBEDToIOCResourceMap.h"

class MQTTTransport : public Transport {
    private:
        PubSubClient         *m_mqtt;
        MBEDToIOCResourceMap *m_map;
        char                  m_topic[MQTT_IOC_TOPIC_LEN+1];
        char                  m_endpoint_name[PERSONALITY_NAME_LEN+1];
        int                   m_ping_counter;
        int                   m_ping_countdown;
        
    public:
        MQTTTransport(Logger *logger,void *endpoint,MBEDToIOCResourceMap *map);
        virtual ~MQTTTransport();
       
        void processMessage(char *message_name,char *payload, unsigned int payload_length);
    
        virtual bool connect();
        virtual bool disconnect();
        
        virtual void checkAndProcess();
 
        char *getEndpointNameFromTopic(char *topic);
        
        bool isPongMessage(char *topic,char *payload,int payload_length);
        void processPongMessage(char *payload,int payload_length);
        
    private:
        char *makeID(char *id_template, char *buffer);
        void initTopic();
        char *getTopic();
        char *mapIOCResourceToEndpointResource(char *ioc_name);
        void sendResult(char *endpoint_name,char *parameter_name,char *value,bool success);
        MBEDToIOCResourceMap *getMap();
        bool isDimmingResource(char *resource);
        bool sendPingMessage();
};

#endif // ___MQTTTRANSPORT_H_