/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

 // class support
 #include "IOCEndpoint.h"
 
 // MBED instance support
 #include "MBEDEndpoint.h"
  
 // default constructor
 IOCEndpoint::IOCEndpoint(Logger *logger,void *endpoint) : BaseClass(logger,endpoint) {
 }
 
 // default destructor
 IOCEndpoint::~IOCEndpoint() {
 }
 
 // build out the IOC Payload
 char *IOCEndpoint::buildLightPayload(char *data,int data_length,Light *light) {
     char tmp[TEMP_BUFFER_LEN+1];
     
     // MBED Endpoint
     MBEDEndpoint *endpoint = (MBEDEndpoint *)this->getEndpoint();
      
     // construct the payload for Load/Updates
     ResourceFactory *factory = light->getResourceFactory();
     
     // start the buffer
     strcat(data,"{");
     
     // loop through the resources and build a JSON representation for the payload
     for(int i=0;i<factory->numResources();++i) {
         // get the ith resource
         Resource *resource = factory->getResource(i);
         if (resource != NULL) {
             // add to the JSON payload
             char *name = endpoint->getMap()->endpointNameToIOCName(resource->getName());
             char *value = resource->getValue();
             
             // make sure that we have a positive IOC resource match for the NSP resource 
             if (name != NULL && strlen(name) > 0) {
                 // Handle LOCATION a special way
                 if (strcmp(name,"LOCATION") != 0) {
                     // standard name,value for IOC
                     sprintf(tmp, "\"%s\":\"%s\",",name,value); 
                  }
                 else {
                     // IOC expects "Point(X,Y)" for LOCATION
                     sprintf(tmp, "\"%s\":\"Point(%s)\",",name,value); 
                 }   
                 strcat(data,tmp);
            
                 // Handle /dev/addldata 
                 char *dev_addldata = endpoint->getMap()->endpointNameToIOCName("/dev/addldata");
                 if (dev_addldata != NULL && strcmp(name,dev_addldata) == 0 && light != NULL && light->getExternalID() > 0) {
                     char buf[IOC_IOC_ID_LEN+1]; memset(buf,0,IOC_IOC_ID_LEN+1); sprintf(buf,"%d",light->getExternalID());
                     sprintf(tmp,"\"%s\":\"id:%s\",",name,buf);
                     strcat(data,tmp);
                 }
             }
         }
     }
     
     // Special Case: STARTDATETIME
     strcat(data,ENDPOINT_STARTTIME);
     
     // Special Case: ENDDATETIME
     strcat(data,ENDPOINT_STOPTIME);
                
     // Special Case: NAME
     sprintf(tmp,"\"NAME\":\"%s\",",light->getName());
     strcat(data,tmp);
          
     // Special Case: TIMEZONEOFFSET
     strcat(data,ENDPOINT_TIMEZONE);
          
     // close
     strcat(data,"}");
     
     // DEBUG
     //this->logger()->log("Loading Payload: %s",data);
     
     // return the payload
     return data;
 }
  
 // save the IOC ID for our Personality
 void IOCEndpoint::saveExternalID(Personality *instance,char *json) {
     if (json != NULL) {          
         //this->logger()->log("RESULT: %s",json);
         
         // look for "id":
         char *check = "\"id\":";
         char *pos1 = strstr(json,check);
         if (pos1 != NULL) {
             char *pos2 = strstr(pos1,","); 
             if (pos1 != NULL && pos2 != NULL && pos2 > pos1) {
                 pos1 += strlen(check);
                 int length = pos2 - pos1;  
                 char str_ioc_id[IOC_IOC_ID_LEN+1];
                 memset(str_ioc_id,0,IOC_IOC_ID_LEN+1);
                 strncpy(str_ioc_id,pos1,length);
                 
                 // DEBUG
                 //this->logger()->log("IOC ID found: %s",str_ioc_id);
                 
                 // parse into int  
                 int ioc_id = 0;             
                 sscanf(str_ioc_id,"%d",&ioc_id);
                          
                 // save the IOC ID
                 if (ioc_id > 0) instance->setExternalID(ioc_id);
             }
             else {
                 // cannot find the ID tag in the result JSON
                 this->logger()->log("Cannot find the IOC ID in the JSON result");
                 this->logger()->log("JSON: %s",json);
             }
         }
         else {
             // cannot find the ID tag in the result JSON
             this->logger()->log("Cannot find the IOC ID in the JSON result");
             this->logger()->log("JSON: %s",json);
        }
     }
  }