 /* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 // class definition
 #include "EmulatedLightResourceFactory.h"
 
 // MBEDEndpoint support
 #include "MBEDEndpoint.h"
 
 // MBED supports Battery Emulation
 #include "MBEDBattery.h"
 
 // MBED supports Current Emulation
 #include "MBEDCurrent.h"
 
 // MBED supports Temperature Sensing
 #include "MBEDTemperature.h"
 
 // MBED supports GPS Emulation
 #include "MBEDgps.h"
 
 // MBED supports RSSI Emulation
 #include "MBEDrssi.h"
 
 // MBED supports Voltage Emulation
 #include "MBEDVoltage.h"
 
 // MBED supports Wattage Emulation
 #include "MBEDWattage.h"
 
 // Initializers
 void init_battery(Resource *resource) { if (resource != NULL) new MBEDBattery(resource->logger(),resource); }
 void init_current(Resource *resource) { if (resource != NULL) new MBEDCurrent(resource->logger(),resource); }
 void init_gps(Resource *resource) { if (resource != NULL) new MBEDgps(resource->logger(),resource); }
 void init_rssi(Resource *resource) { if (resource != NULL) new MBEDrssi(resource->logger(),resource); }
 void init_temperature(Resource *resource) { if (resource != NULL) new MBEDTemperature(resource->logger(),resource); }
 void init_voltage(Resource *resource) { if (resource != NULL) new MBEDVoltage(resource->logger(),resource); }
 void init_wattage(Resource *resource) { if (resource != NULL) new MBEDWattage(resource->logger(),resource); }
 
  // NSP supports Light Dimming
 extern void emulated_light_dimming_cb();
 
 // NSP supports Light Switch 
 extern void emulated_light_switch_cb();
 
 // get the IP address if we are using Ethernet
 #ifndef CELLULAR_NETWORK
    #include "EthernetInterface.h"
    extern EthernetInterface ethernet;
 #endif
 
 // default constructor
 EmulatedLightResourceFactory::EmulatedLightResourceFactory(Logger *logger,void *endpoint) : EmulatedResourceFactory(logger,endpoint) { 
    this->initGPSCoords(); 
 }
 
 // default destructor
 EmulatedLightResourceFactory::~EmulatedLightResourceFactory() {
 }
 
 // initialize our GPS coords
 void EmulatedLightResourceFactory::initGPSCoords() {
     memset(this->m_gps_coords,0,PREFERENCE_VALUE_LEN+1);
     MBEDEndpoint *endpoint = (MBEDEndpoint *)this->getEndpoint();
     if (endpoint != NULL && endpoint->preferences() != NULL)
        endpoint->preferences()->getPreference("coords",this->m_gps_coords,PREFERENCE_VALUE_LEN,ENDPOINT_GPS_COORDS);
     else
        strcpy(this->m_gps_coords,ENDPOINT_GPS_COORDS);
     for(int i=0;i<strlen(this->m_gps_coords);++i) if (this->m_gps_coords[i] == ',') this->m_gps_coords[i] = ' ';
 }
 
 // get our GPS coords from preferences
 char *EmulatedLightResourceFactory::getGPSCoords() { return this->m_gps_coords; }
 
 // create resources for an Emulated Light Resource
 void EmulatedLightResourceFactory::createResources(char *endpoint_name) {
    // create all of the resources we expect for this endpoint
    this->createResource("/dev/addldata","id:0");
    this->createResource("/dev/location",ENDPOINT_LOCATION);
    //this->createResource("/fw/devtype","Light");
    this->createResource("/dev/bat","5.0V",(void *)&init_battery,NULL);
    this->createResource("/sen/I","0.1A",(void *)&init_current,NULL);
    //this->createResource("/dev/I","0.1A",(void *)&init_current,NULL);
#ifndef CELLULAR_NETWORK
    this->createResource("/nw/ipaddr",ethernet.getIPAddress());
#else
    this->createResource("/nw/ipaddr","0.0.0.0");
#endif
    this->createResource(endpoint_name,"/lt/0/dim",LIGHT_DIM_STATE,(void *)&emulated_light_dimming_cb);          // Action: dim/brighten light
    //this->createResource("/nw/eripaddr","N/A");
    this->createResource(endpoint_name,"/lt/0/on",LIGHT_DEFAULT_STATE,(void *)&emulated_light_switch_cb);             // Action: light on/off
    //this->createResource(endpoint_name,"/lt/0/ctr",LIGHT_DEFAULT_STATE,(void *)&emulated_light_switch_cb);             // Action: light on/off
    this->createResource("/dev/mdl",MQTT_ENDPOINT_TYPE);
    this->createResource("/dev/mfg",PLATFORM_STRING);
    this->createResource("/gps/int","60");
    this->createResource("/gps/fix","1");
    //this->createResource("/nw/pipaddr","N/A");
    //this->createResource("/dev/W","0.1W",(void *)&init_wattage,NULL);
    //this->createResource("/nw/prssi","-75",(void *)&init_rssi,NULL);
    this->createResource("/sen/temp","10.0C",(void *)&init_temperature,NULL);
    //this->createResource("/dev/t","10.0C",(void *)&init_temperature,NULL);
    this->createResource("/sen/V","5.0V",(void *)&init_voltage,NULL);
    //this->createResource("/dev/V","5.0V",(void *)&init_voltage,NULL);
    this->createResource("/gps/loc",this->getGPSCoords(),(void *)&init_gps,NULL);
    this->createResource("/ns/nspaddr","(NA)");
    this->createResource(endpoint_name,"/dev/panic","0",(void *)&emulated_light_switch_cb);             // Action: light on/off
    
#ifdef MAC_ADDRESS
    extern char fmt_mac[RESOURCE_VALUE_LEN+1];
    this->createResource("/nw/macaddr",fmt_mac);
#else
    this->createResource("/nw/macaddr","00:00:00:00:00");
#endif
 } 
 
 