/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef _IOC_HTTP_TRANSPORT_H_
#define _IOC_HTTP_TRANSPORT_H_

// Base Class
#include "HTTPTransport.h"

class IOCHTTPTransport : public HTTPTransport {
    private:
        char        m_url_buffer[IOC_REST_URL_LEN+1];

    public:
        IOCHTTPTransport(Logger *error_handler,void *endpoint);
        virtual ~IOCHTTPTransport();
        
        virtual bool httpGet(char *url,char *result,int result_length);
        virtual bool httpPut(char *url,char *data,int data_length,char *result,int result_length);
        virtual bool httpPost(char *url,char *data,int data_length,char *result,int result_length);
        virtual bool httpDelete(char *url,char *data,int data_length);
        
        virtual bool loadEndpoint(char *data,int data_length,char *result,int result_length);
        virtual bool updateEndpoint(int ioc_id,char *data,int data_length,char *result,int result_length); 
                
    private:
        char *createIOCLoadURL();
        char *packageData(char *verb,char *data,int ioc_id);
        char *createIOCUpdateURL(int ioc_id);
        char *createIOCUpdateURL(int ioc_id,bool useRedirector);
 };

#endif // _IOC_HTTP_TRANSPORT_H_