/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef _EMULATED_RESOURCE_FACTORY_H_
#define _EMULATED_RESOURCE_FACTORY_H_

// Base Class
#include "ResourceFactory.h"

// Emulated callback structure
typedef void (*EmulatedCallbackPointer)();

// Logger support
#include "Logger.h"

// Resource Initializer callback structure
typedef void (*resourceInitializer)(Resource *);

class EmulatedResourceFactory : public ResourceFactory {        
    public:
        EmulatedResourceFactory(Logger *logger,void *endpoint);
        virtual ~EmulatedResourceFactory();
                      
        virtual void createResources(char *endpoint_name) = 0;
        
        bool setResourceValue(char *name, char *value);
    
    protected:
        virtual void createResource(char *endpoint_name,char *name,char *value,void *cb);
        virtual void createResource(char *name,char *value);
        void createResource(char *name,char *value,void *io,void *notused);
 };


#endif // _EMULATED_RESOURCE_FACTORY_H_