/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 // class definition
 #include "EmulatedResourceFactory.h"
 
 // MBEDEndpoint instance support
 #include "MBEDEndpoint.h"
  
 // default constructor
 EmulatedResourceFactory::EmulatedResourceFactory(Logger *logger,void *endpoint) : ResourceFactory(logger,endpoint) {  
 }
 
 // default destructor
 EmulatedResourceFactory::~EmulatedResourceFactory() {
 }
 
 // resource creators for the EmulatedResourceFactory...
 void EmulatedResourceFactory::createResource(char *name,char *value) { ResourceFactory::createResource(name,value); }
 void EmulatedResourceFactory::createResource(char *ep_name,char *name,char *value,void *cb) { ResourceFactory::createResource(ep_name,name,value,cb); }
 void EmulatedResourceFactory::createResource(char *name,char *value,void *io,void *notused) {
     MBEDEndpoint *endpoint = (MBEDEndpoint *)this->getEndpoint();
     char *ep_name = NULL; if (endpoint != NULL) ep_name = endpoint->getEndpointName();
     this->m_list[this->m_count] = new Resource(this->logger(),ep_name,name,value,NULL);
     if (io != NULL && this->m_list[this->m_count] != NULL) {
        resourceInitializer initializer = (resourceInitializer)io;
        (initializer)(this->m_list[this->m_count]);
     }
     if (this->m_list[this->m_count] != NULL) ++this->m_count;
 }
  
 // set a resource value (AND trigger the Emulated actions if registered)
 bool EmulatedResourceFactory::setResourceValue(char *name, char *value) {
     // set the resource value
     bool success = ResourceFactory::setResourceValue(name,value);
     if (success) {
         // invoke an action if registered
         EmulatedCallbackPointer cb = (EmulatedCallbackPointer)this->getCallbackPointer(name);
         if (cb != NULL) {
             // invoke the callback
             this->logger()->log("Invoking Action...");
             cb();
         }
         
         // additionally update the IOC with a REST call to update its record of us (assuming 1 personality/endpoint!!)
         MBEDEndpoint *endpoint = (MBEDEndpoint *)this->getEndpoint();
         endpoint->updatePersonality(0);
     }
     return success;
 }