/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "ResourceFactory.h"
 #include "MBEDEndpoint.h"
 
 // default constructor
 ResourceFactory::ResourceFactory(Logger *logger,void *endpoint) : BaseClass(logger,endpoint) {
     this->m_count = 0;
     for(int i=0;i<NUM_RESOURCES;++i) this->m_list[i] = NULL;
 }
 
 // default destructor
 ResourceFactory::~ResourceFactory() {
     for(int i=0;i<NUM_RESOURCES;++i) if (this->m_list[i] != NULL) delete this->m_list[i];
 }
 
 // get our number of resources
 int ResourceFactory::numResources() { return this->m_count; }
 
 // get the ith resource
 Resource *ResourceFactory::getResource(int index) { if (index >= 0 && index < NUM_RESOURCES) return this->m_list[index]; return NULL;};
  
 // create resources (base class does nothing)
 void ResourceFactory::createResources(char *endpoint_name) { ; }
 
 // create a resource value
 void ResourceFactory::createResource(char *name,char *value) { 
    MBEDEndpoint *endpoint = (MBEDEndpoint *)this->getEndpoint();
    char *ep_name = NULL; if (endpoint != NULL) ep_name = endpoint->getEndpointName();
    this->createResource(ep_name,name,value,NULL); 
 }
 
 void ResourceFactory::createResource(char *endpoint_name,char *name,char *value,void *cb) {
     this->m_list[this->m_count] = new Resource(this->logger(),endpoint_name,name,value,cb);
     ++this->m_count;
 }
 
 // get a resource value (null in base class)
 char *ResourceFactory::getResourceValue(char *name) { 
    char *value = NULL;
    bool found = false;
    
    // loop through the resource list
    for(int i=0;i<this->m_count && !found && name != NULL;++i) {
        if (strcmp(this->m_list[i]->getName(),name) == 0) {
            found = true;
            value = this->m_list[i]->getValue();
            //this->logger()->log("Getting Resource: %s Value: %s",name,value);
        }
    }
    
    return value;
 }
 
 // set a resource value 
 bool ResourceFactory::setResourceValue(char *name, char *value) {
    bool found = false;
    bool set = false;
    
    // loop through the resource list
    for(int i=0;i<this->m_count && !found && name != NULL && value != NULL;++i) {
        if (strcmp(this->m_list[i]->getName(),name) == 0) {
            found = true;
            this->logger()->log("Setting Resource: %s Value: %s",name,value);
            this->m_list[i]->setValue(value);
            set = true;
        }
    }
    
    return set;
}

// get the callback pointer
void *ResourceFactory::getCallbackPointer(char *name) {
    void *cb = NULL;
    bool found = false;
    
    // loop through the resource list
    for(int i=0;i<this->m_count && !found && name != NULL;++i) {
        if (strcmp(this->m_list[i]->getName(),name) == 0) {
            found = true;
            cb = this->m_list[i]->getCallbackPointer();
         }
    }
    
    return cb;
}

