/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "Resource.h"
 #include "MBEDio.h"
    
 // default constructor
 Resource::Resource(Logger *logger,char *ep_name,char *name,char *value,void *cb) : BaseClass(logger,NULL) {
     this->m_io = NULL;
     memset(this->m_name,0,RESOURCE_NAME_LEN+1);
     memset(this->m_value,0,RESOURCE_VALUE_LEN+1);
     memset(this->m_endpoint_name,0,PERSONALITY_NAME_LEN+1);
     this->setName(name);
     this->setValue(value);
     this->setCallbackPointer(cb);
     this->plumb(ep_name,this->m_name);
 }
 
 // default destructor
 Resource::~Resource() {
 }
  
 // get and set the name of the resource
 char *Resource::getName() { return this->m_name; }
 void Resource::setName(char *name) { 
    if (name != NULL) {
        memset(this->m_name,0,RESOURCE_NAME_LEN+1);
        strncpy(this->m_name,name,this->min(RESOURCE_NAME_LEN,strlen(name))); 
    }
 }
 
 // get the value of the resource
 char *Resource::getValue() { this->extract(this->getName()); return this->getValuePointer(); }
 char *Resource::getValuePointer() { 
    //this->logger()->log("GET: Name: %s Value: %s",this->m_name,this->m_value); 
    return this->m_value; 
 }
 
 // set the value of the resource
 void Resource::setValue(char *value) { this->setValue(value,strlen(value)); }
 void Resource::setValue(char *value,int length) {
     if (value != NULL && length > 0) {
         memset(this->m_value,0,RESOURCE_VALUE_LEN+1);
         strncpy(this->m_value,value,this->min(RESOURCE_VALUE_LEN,length));
         //this->logger()->log("SET: Name: %s Value: %s",this->m_name,this->m_value); 
     }
 }
 
 // plumb the resource (base class does nothing other than save the endpoint_name)
 void Resource::plumb(char *ep_name,char *name) { 
    //this->logger()->log("Plumbing Resource - Endpoint: %s Resource: %s",ep_name,name);
    memset(this->m_endpoint_name,0,PERSONALITY_NAME_LEN+1);
    if (ep_name != NULL) {
        memset(this->m_endpoint_name,0,PERSONALITY_NAME_LEN+1);
        strncpy(this->m_endpoint_name,ep_name,this->min(PERSONALITY_NAME_LEN,strlen(ep_name))); 
    }
 }
 
 // extract the resource value 
 void Resource::extract(char *name) { 
    if (this->m_io != NULL) {
        //this->logger()->log("EXTRACT: Invoking MBEDio UPDATE for Name: %s Value: %s",this->m_name,this->m_value);
        MBEDio *io = (MBEDio *)this->m_io;
        io->update();
    }
 }
 
 // get the endpoint anme
 char *Resource::getEndpointName() { return this->m_endpoint_name; }
 
 // set the base I/O
 void Resource::setIO(void *io) { 
    //this->logger()->log("SET: MBEDio SET for Name: %s Value: %s",this->m_name,this->m_value); 
    this->m_io = io; 
 }
 
 // get the base I/O
 void *Resource::getIO() { return this->m_io; }
 
 // set the internal resource linkage
 void  Resource::setCallbackPointer(void *cb) { this->m_cb = cb; }
 void *Resource::getCallbackPointer() { return this->m_cb; }