/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef _LOGGER_H_
#define _LOGGER_H_

// Tunables
#include "Definitions.h"

// Support for std args
#include <stdarg.h>

// LCD Support
#ifdef _ENDPOINT_UBLOX_PLATFORM
    #include "C12832.h"    
    #define LCDCLASS     C12832
#endif

#ifdef _ENDPOINT_NXP_PLATFORM
   #include "C12832_lcd.h" 
   #define LCDCLASS      C12832_LCD   
#endif

#ifdef _ENDPOINT_FREEDOM_PLATFORM   
    #include "C12832_lcd.h"  
    #define LCDCLASS      C12832_LCD   
#endif

#if defined(EH_USE_MUTEXES) || defined(NETWORK_MUTEX) || defined(ENABLE_THREADS) || defined(NSP_CELLULAR_NETWORK)
    // RTOS support
    #include "mbed.h"
    #include "rtos.h"
#endif

class Logger {
    private:
        RawSerial      *m_pc;
        LCDCLASS       *m_lcd;
        char            m_message[MAX_LOG_MESSAGE+1];
#ifdef EH_USE_MUTEXES
        Mutex          *m_mutex;
        Mutex          *m_close_mutex;
        Mutex          *m_led_mutex;
        Mutex          *m_rgb_mutex;
#endif
        void           *m_endpoint;
        bool            m_status_lcd;
        
    public:
        Logger(RawSerial *pc,LCDCLASS *lcd);
       ~Logger();
       
       void lcdStatusOnly(bool status_lcd);
       
       void log(const char *format, ...); 
       void logConsole(const char *format, ...); 
       void log_memory(const char *format, ...);
       void checkForExit(); 
       
       void pause(const char *format, ...);
       
       void turnLEDRed();
       void turnLEDGreen();
       void turnLEDBlue();
       void turnLEDPurple();
       void turnLEDBlack();
       void turnLEDYellow();
       void turnLEDOrange();
       
       void blinkTransportTxLED();
       void blinkTransportRxLED();

#ifdef EH_USE_MUTEXES       
       void releaseMutexes();
#endif

       void led2On();
       void led2Off();
       void led3On();
       void led3Off();
       
       void  setEndpoint(void *endpoint);
       void *getEndpoint();
        
    private:
        void setRGBLED(float H, float S, float V);
        void blinkLED(DigitalOut led);
        void resetLEDs();
        void changeLED(DigitalOut led,bool onoff);
};

#endif // _LOGGER_H_