/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef _LIGHT_H_
#define _LIGHT_H_

// Base class support
#include "Personality.h"

// Philips Light Support
#include "PhilipsLight.h"

// External LED Light Support
#include "CopCarLEDFlasher.h"

// APMDemoLight Support
#include "APMDemoLight.h"

class Light : public Personality {
    private:
        void              *m_dimmer_action;
        void              *m_switch_action;
        
        PhilipsLight      *m_pl;
        ExternalLEDLight  *m_ext_led;
 #ifdef APM_LIGHT_PERSONALITY
        APMDemoLight      *m_apm_light;
 #endif
 
 #ifdef ENABLE_THREADS       
        Thread            *m_blinking_thread;
 #endif
        int                m_last_state;
        bool               m_is_blinking;
        bool               m_forward;
        
    protected:
        int                m_current_state;
            
    public:
        Light(Logger *logger,Transport *transports[NUM_TRANSPORTS],int instance,void *endpoint);
        virtual ~Light();
               
        void  setDimmerAction(void *dimmer_action);
        void  setSwitchAction(void *switch_action);
    
        virtual void on();
        virtual void off();
        void blink();
        virtual void dim(int value);   
                
        void updateDirection();
        void blinkLight();
        
        void initLight();
        
    protected:
        void *getDimmerAction();
        void *getSwitchAction(); 
        
    private:
        PhilipsLight     *pl();  
        ExternalLEDLight *extled();
 #ifdef APM_LIGHT_PERSONALITY 
        APMDemoLight     *apmlight();  
 #endif
        void              startBlinking();
        void              stopBlinking();
        void              manageBlinkingThread();
        void              startBlinkingThread();
        void              stopBlinkingThread(); 
};

#endif // _LIGHT_H_