/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 #include "mbed.h"
 
 #include "HTTPTransport.h"
 
 // Endpoint Support
 #include "MBEDEndpoint.h"
 
 #ifdef NETWORK_MUTEX
 #include "rtos.h"
 extern Mutex *network_mutex;
 #endif
  
 // HTTP Client
 extern HTTPClient _http;
 
 // default constructor
 HTTPTransport::HTTPTransport(Logger *logger,void *endpoint) : Transport(logger,endpoint) {
     this->m_http = &_http;
     this->m_connected = true;
 }
 
 // constructor with custom HTTPClient binding
 HTTPTransport::HTTPTransport(HTTPClient *http,Logger *logger,void *endpoint) : Transport(logger,endpoint) {
     this->m_http = http;
     this->m_connected = true;
 }
 
 // default destructor
 HTTPTransport::~HTTPTransport() {
 }
 
 // Basic Auth
 void HTTPTransport::basicAuth(char *username,char *pw) { this->m_http->basicAuth(username,pw); }
         
 // HTTP Get
 bool HTTPTransport::httpGet(char *url,char *result,int result_length,int timeout) {
    this->logger()->blinkTransportTxLED();
 #ifdef NETWORK_MUTEX
    if (network_mutex != NULL) network_mutex->lock();
 #endif
    int status = 0;
    if (timeout > 0) status = this->m_http->get(url,result,result_length,timeout);
    else status = this->m_http->get(url,result,result_length);
 #ifdef NETWORK_MUTEX
    if (network_mutex != NULL) network_mutex->unlock();
 #endif
    this->logger()->blinkTransportRxLED();
    //this->logger()->log("httpGet: Status: %d",status);
    return (status == 0);
 }
 
 // HTTP Put
 bool HTTPTransport::httpPut(char *url,char *data,int data_length,char *result,int result_length) {
     HTTPText output(data,data_length);
     HTTPText input(result,result_length);
     this->logger()->blinkTransportTxLED();
 #ifdef NETWORK_MUTEX
     if (network_mutex != NULL) network_mutex->lock();
 #endif
     int status = this->m_http->put(url,output,&input);
 #ifdef NETWORK_MUTEX
     if (network_mutex != NULL) network_mutex->unlock();
 #endif
     this->logger()->blinkTransportRxLED();
     //this->logger()->log("httpPut: Status: %d",status);
     return (status == 0);
 }
 
 // HTTP Post
 bool HTTPTransport::httpPost(char *url,char *data,int data_length,char *result,int result_length) {
     HTTPText output(data,data_length);
     HTTPText input(result,result_length);
     this->logger()->blinkTransportTxLED();
 #ifdef NETWORK_MUTEX
     if (network_mutex != NULL) network_mutex->lock();
 #endif
     int status = this->m_http->post(url,output,&input);
 #ifdef NETWORK_MUTEX
     if (network_mutex != NULL) network_mutex->unlock();
 #endif
     this->logger()->blinkTransportRxLED();
     //this->logger()->log("httpPost: Status: %d",status);
     return (status == 0);
 }
 
 // HTTP Delete
 bool HTTPTransport::httpDelete(char *url,char *data,int data_length) {
     HTTPText input(data,data_length);
     this->logger()->blinkTransportTxLED();
 #ifdef NETWORK_MUTEX
     if (network_mutex != NULL) network_mutex->lock();
 #endif
     int status = this->m_http->del(url,&input);
 #ifdef NETWORK_MUTEX
     if (network_mutex != NULL) network_mutex->unlock();
 #endif
     this->logger()->blinkTransportRxLED();
     //this->logger()->log("httpDelete: Status: %d",status);
     return (status == 0);
 }