/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 
#ifndef ___TRANSPORT_H_
#define ___TRANSPORT_H_

// Definitions
#include "Definitions.h"

// BaseClass support
#include "BaseClass.h"

class Transport : public BaseClass {        
    public:
       Transport(Logger *error_handler,void *endpoint);
       virtual ~Transport();
       
       virtual bool connect();
       virtual bool disconnect();
       
       virtual void checkAndProcess();
       
       virtual bool loadEndpoint(char *data,int data_length,char *result,int result_length);
       virtual bool updateEndpoint(int ioc_id,char *data,int data_length,char *result,int result_length); 
           
    protected:
        bool          m_connected;
};

#endif // ___TRANSPORT_H_