/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 // class support
 #include "Personality.h"
 
 // MBED Endpoint linkage
 #include "MBEDEndpoint.h"
 
 // default constructor
 Personality::Personality(Logger *logger,Transport *transports[NUM_TRANSPORTS],int instance,void *endpoint,char *type) : BaseClass(logger,endpoint) {
    this->m_resources = ((MBEDEndpoint *)endpoint)->initResourceFactory();
    this->m_external_id = 0;
    
    for(int i=0;i<NUM_TRANSPORTS;++i) this->m_transports[i] = transports[i];
    memset(this->m_name,0,PERSONALITY_NAME_LEN+1);
    memset(this->m_type,0,PERSONALITY_NAME_LEN+1);
    strcpy(this->m_type,type);
    sprintf(this->m_name,PERSONALITY_NAME,instance);
    this->getResourceFactory()->createResources(this->getName());
 }
 
 // default destructor
 Personality::~Personality() {
    if (this->m_resources != NULL) delete this->m_resources;
 }
 
 // get the resource factory
 ResourceFactory *Personality::getResourceFactory() { return this->m_resources; }
 
 // get the Personality name
 char *Personality::getName() { return this->m_name; }
 
 // get the Personality type
 char *Personality::getType() { return this->m_type; }
 
 // set the External ID
 void Personality::setExternalID(int external_id) { 
    this->m_external_id = external_id; 
    char buffer[PREFERENCE_VALUE_LEN+1];
    memset(buffer,0,PREFERENCE_VALUE_LEN+1);
    sprintf(buffer,"id:%d",external_id);
    this->getResourceFactory()->setResourceValue(EXTERNAL_LINKAGE_RESOURCE,buffer);
 }
 
 // get the External ID
 int Personality::getExternalID() { return this->m_external_id; }

   
 
