/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "mbed.h"
 #include "MapEntry.h"

 // default constructor 
 MapEntry::MapEntry(char *ioc_name,char *mbed_name) {
     memset(this->m_mbed_name,0,MAX_NAME_LENGTH+1);
     memset(this->m_ioc_name,0,MAX_NAME_LENGTH+1);
     memset(this->m_ioc_nickname,0,MAX_NAME_LENGTH+1);
     strncpy(this->m_mbed_name,mbed_name,this->min(strlen(mbed_name),MAX_NAME_LENGTH));
     strncpy(this->m_ioc_name,ioc_name,this->min(strlen(ioc_name),MAX_NAME_LENGTH));
 }
 
 // constructor
 MapEntry::MapEntry(char *ioc_name,char *mbed_name,char *ioc_nickname) {
     memset(this->m_mbed_name,0,MAX_NAME_LENGTH+1);
     memset(this->m_ioc_name,0,MAX_NAME_LENGTH+1);
     memset(this->m_ioc_nickname,0,MAX_NAME_LENGTH+1);
     strncpy(this->m_mbed_name,mbed_name,this->min(strlen(mbed_name),MAX_NAME_LENGTH));
     strncpy(this->m_ioc_name,ioc_name,this->min(strlen(ioc_name),MAX_NAME_LENGTH));
     strncpy(this->m_ioc_nickname,ioc_nickname,this->min(strlen(ioc_nickname),MAX_NAME_LENGTH));
 }
 
 // destructor
 MapEntry::~MapEntry() {
 }
  
 // get the IOC name     
 char *MapEntry::iocName() { return this->m_ioc_name; }
 
 // get the IOC nickname
 char *MapEntry::iocNickName() { if (strlen(this->m_ioc_nickname) > 0) return this->m_ioc_nickname; return NULL; }
 
 // get the MBED name
 char *MapEntry::mbedName() { return this->m_mbed_name; }
 
  // min function
 int MapEntry::min(int value1,int value2) {
    if (value1 < value2) return value1;
    return value2;
 }
