/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "MBEDio.h"
 
 // default constructor
 MBEDio::MBEDio(Logger *logger,Resource *resource) : BaseClass(logger,resource) {
    if (resource != NULL) resource->setIO(this);
 }
 
 // destructor
 MBEDio::~MBEDio() {
 }
 
 // get the float value (refreshes the value)
 float MBEDio::floatValue() { 
    this->update(); 
    float floatValue = 0.0;
    if (this->resource() != NULL && this->resource()->getValuePointer() != NULL) sscanf(this->resource()->getValuePointer(),"%f",&floatValue);
    return floatValue; 
 }
 
 // get the int value (refreshes the value)
 int MBEDio::intValue() { 
    this->update();  
    int intValue = 0;
    if (this->resource() != NULL && this->resource()->getValuePointer() != NULL) sscanf(this->resource()->getValuePointer(),"%d",&intValue);
    return intValue;  
 }
 
 // get the string value (refreshes the value)
 char *MBEDio::stringValue() { 
    if (this->resource() != NULL) {
        this->update(); 
        return this->resource()->getValuePointer();
    }
    else {
        this->logger()->log("stringValue: returning NULL - no resource bound to me"); 
        return NULL;
    }
 }

 // get the Resource (held in BaseClass as endpoint()...)
 Resource *MBEDio::resource() { return (Resource *)this->getEndpoint(); }