/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "MBEDToIOCResourceMap.h"
 
 // default constructor
 MBEDToIOCResourceMap::MBEDToIOCResourceMap(Logger *logger) : BaseClass(logger,NULL) {
     for(int i=0;i<NUM_MAPPINGS;++i) this->m_map[i] = NULL;
     this->m_count = 0;
     this->createMap();
 }
 
 // destructor
 MBEDToIOCResourceMap::~MBEDToIOCResourceMap() {
     for(int i=0;i<this->m_count;++i)
        if (this->m_map[i] != NULL) delete this->m_map[i];
 }
  
 // get the IOC equivalent resource name from the Endpoint resource name
 char *MBEDToIOCResourceMap::endpointNameToIOCName(char *mbed_name) {
     bool found = false;
     char *ioc_name = NULL;
          
     // lookup the IOC name and map it to an MBED (NSP) name
     for(int i=0;i<this->m_count && !found && this->m_map[i] != NULL && mbed_name != NULL;++i) {
         if (strcmp(this->m_map[i]->mbedName(),mbed_name) == 0) {
             found = true;
             ioc_name = this->m_map[i]->iocName();
         }
     }
     return ioc_name;
 }
       
 // get the Endpoint resource name from the IOC resource name given 
 char *MBEDToIOCResourceMap::iocNameToEndpointName(char *ioc_name) {
     bool found = false;
     char *mbed_name = NULL;
     
     // convert if we have a nickname
     char *actual_ioc_name = this->convertFromNickName(ioc_name);
     
     // lookup the IOC name and map it to an MBED (NSP) name
     for(int i=0;i<this->m_count && !found && this->m_map[i] != NULL && ioc_name != NULL;++i) {
         if (strcmp(this->m_map[i]->iocName(),actual_ioc_name) == 0) {
             found = true;
             mbed_name = this->m_map[i]->mbedName();
         }
     }
     return mbed_name;
 }
 
 // convert from an IOC nickname to the actual IOC property name
 char *MBEDToIOCResourceMap::convertFromNickName(char *ioc_name) {
     char *actual_name = ioc_name;
     bool found = false;

     for(int i=0;i<this->m_count && !found && this->m_map[i] != NULL && ioc_name != NULL;++i) {
         if (this->m_map[i]->iocNickName() != NULL && strcmp(this->m_map[i]->iocNickName(),ioc_name) == 0) {
             found = true;
             actual_name = this->m_map[i]->iocName();
         }
     }
     
     return actual_name;
 }
 
 // create our map - this MUST match the Resource Mapping found in the gateway mapping database
 void MBEDToIOCResourceMap::createMap() {
     this->m_map[this->m_count++] = new MapEntry("Property_1","/dev/addldata");
     this->m_map[this->m_count++] = new MapEntry("Property_2","/dev/location");
     this->m_map[this->m_count++] = new MapEntry("Property_3","/dev/bat");
     this->m_map[this->m_count++] = new MapEntry("Property_4","/sen/I");
     this->m_map[this->m_count++] = new MapEntry("Property_5","/nw/ipaddr");
     this->m_map[this->m_count++] = new MapEntry("Property_6","/lt/0/dim","Dimming");
     this->m_map[this->m_count++] = new MapEntry("Property_7","/nw/eripaddr");
     this->m_map[this->m_count++] = new MapEntry("Property_8","/lt/0/on","EndpointState");
     this->m_map[this->m_count++] = new MapEntry("Property_9","/dev/mdl");
     this->m_map[this->m_count++] = new MapEntry("Property_10","/gps/int");
     this->m_map[this->m_count++] = new MapEntry("Property_11","/gps/fix");
     this->m_map[this->m_count++] = new MapEntry("Property_12","/dev/panic","Panic");
     this->m_map[this->m_count++] = new MapEntry("Property_13","/nw/pipaddr");
     this->m_map[this->m_count++] = new MapEntry("Property_14","/nw/prssi");
     this->m_map[this->m_count++] = new MapEntry("Property_15","/sen/temp");
     this->m_map[this->m_count++] = new MapEntry("Property_16","/sen/V");
     this->m_map[this->m_count++] = new MapEntry("LOCATION","/gps/loc");
     
     // DEBUG
     this->logger()->log("Installed %d Resource Mappings.",this->m_count);
 }