/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "LightSwitchAction.h"
  
 // default constructor
 LightSwitchAction::LightSwitchAction(Logger *logger,Light *light) : Action(logger) {
     this->m_light = light;
 }
 
 // destructor
 LightSwitchAction::~LightSwitchAction() {
 }
 
 // Toggle the Light Switch
 void LightSwitchAction::toggle() {
    ResourceFactory *resource = this->light()->getResourceFactory();
    char *value = resource->getResourceValue(SWITCH_RESOURCE);
    if (value != NULL && strcmp(value,"1") == 0) {
        this->logger()->log("Turning Light: %s ON",this->light()->getName());
        this->on();
    }
    else if (value != NULL && strcmp(value,"2") == 0) {
        this->logger()->log("Blinking Light: %s...",this->light()->getName());
        this->blink();
    }
    else {
        this->logger()->log("Turning Light: %s OFF",this->light()->getName());
        this->off();
    }
 }
 
 // Light turned ON
 void LightSwitchAction::on() { this->light()->on(); }
 
 // Light turned OFF
 void LightSwitchAction::off() { this->light()->off(); }
 
  // Blink light
 void LightSwitchAction::blink() { this->light()->blink(); }

 // get the light
 Light *LightSwitchAction::light() { return this->m_light; }