/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef _LIGHT_DIMMER_ACTION_H_
#define _LIGHT_DIMMER_ACTION_H_

// Base class
#include "Action.h"

// what we act upon
#include "Light.h"

// The resource we are bound to
#define DIMMING_RESOURCE        "/lt/0/dim"

class LightDimmerAction : public Action { 
    private:
        Light *m_light;
       
    public:
        LightDimmerAction(Logger *logger,Light *light);
        virtual ~LightDimmerAction();
                
        void dim();
        void dim(int value);
        
        Light *light();
};

#endif // _LIGHT_DIMMER_ACTION_H_