/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "ExternalLEDLight.h"
 
 //#ifdef COPCAR_PERSONALITY
 //   PwmOut _ext_led_extra_pwm(EXT_LED_PIN_COPCAR);
 //#endif
  
 // default constructor
 ExternalLEDLight::ExternalLEDLight(PwmOut *led,Logger *logger) : BaseClass(logger,NULL) {
     this->m_led = led;
     this->m_dimming = false;
     sscanf(LIGHT_DEFAULT_STATE,"%d",&this->m_state);
     sscanf(LIGHT_DIM_STATE,"%f",&this->m_dim);
 }
 
 // destructor
 ExternalLEDLight::~ExternalLEDLight() {
     if (this->m_led != NULL) delete this->m_led;
 }
 
 // turn the light on
 void ExternalLEDLight::on() { this->m_state = 1; this->m_dimming = false; this->update(); }
 
 // turn the light off
 void ExternalLEDLight::off() { this->m_state = 0; this->m_dimming = false; this->update(); }
  
 // dim the light (dim is between 0 and 100)
 void ExternalLEDLight::dim(int dim) { this->m_dim = (float)(dim/100.0); this->m_dimming = true; this->update(); }
  
 // set the light state
 void ExternalLEDLight::update() {
    if (this->m_dimming) {
        // dim the light
        *(this->m_led) = this->m_dim;
    }
    else {
        // turn the light on or off
        if (this->m_state == 0) {
            // just turn the LED off
            *(this->m_led) = 0;
//#ifdef COPCAR_PERSONALITY
//            _ext_led_extra_pwm = 0;
//#endif
        }
        else {
            // turn the LED on - but re-adjust for the current dim setting:
            //  - if the dimming is set to 0, then lets go ahead and make the light full bright...
            //  - otherwise we wont see the transition change. 
            if (this->m_dim == 0.0) {
                *(this->m_led) = 1;
//#ifdef COPCAR_PERSONALITY
//                _ext_led_extra_pwm = 1;
//#endif
            }
            else {
                *(this->m_led) = this->m_dim;
            }
        }
    }
 }