/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "CopCarLEDFlasher.h"
   
 // default constructor
 CopCarLEDFlasher::CopCarLEDFlasher(PwmOut *led1,PwmOut *led2,Logger *logger) : ExternalLEDLight(led1,logger) {
     this->m_led2 = led2;
     this->m_toggle = false;
 }
 
 // destructor
 CopCarLEDFlasher::~CopCarLEDFlasher() {
     if (this->m_led2 != NULL) delete this->m_led2;
 }
 
 // turn the light on
 void CopCarLEDFlasher::on() { this->m_state = 1; this->update(); }
 
 // turn the light off
 void CopCarLEDFlasher::off() { this->m_state = 0; this->update(); }
  
 // set the light state
 void CopCarLEDFlasher::update() {
    // turn the light on or off
    if (this->m_state == 0) {
        *(this->m_led2) = 0;
        *(this->m_led) = 0;
    }
    if (this->m_state == 1 || this->m_state == 2) {
        if (this->m_toggle) {
            *(this->m_led2) = 1;
            *(this->m_led) = 0;
        }
        else {
            *(this->m_led2) = 0;
            *(this->m_led) = 1;
        }
        this->m_toggle = !this->m_toggle;
    }
 }