/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef _RESOURCE_H
#define _RESOURCE_H

// BaseClass support
#include "BaseClass.h"

class Resource : public BaseClass {
    private:
        char          m_name[RESOURCE_NAME_LEN+1];
        char          m_value[RESOURCE_VALUE_LEN+1];
        char          m_endpoint_name[PERSONALITY_NAME_LEN+1];
        void         *m_cb;
        void         *m_io;
     
    public:
        Resource(Logger *logger,char *ep_name,char *name,char *value,void *cb);
        virtual ~Resource();
                
        char *getName();
        void  setName(char *name);
        char *getValue();
        char *getValuePointer();
        void  setValue(char *value);
        void  setValue(char *value,int length);
                
        virtual void plumb(char *endpoint_name,char *name);
        virtual void extract(char *name);
        
        void *getCallbackPointer();
        
        void  setIO(void *io);
        void *getIO();
    
    protected:
        char *getEndpointName();
        void  setCallbackPointer(void *cb);        
};

#endif // _RESOURCE_H