/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef _PREFERENCES_H_
#define _PREFERENCES_H_

#include "BaseClass.h"

typedef struct {
    char name[PREFERENCE_NAME_LEN+1];
    char value[PREFERENCE_VALUE_LEN+1];
} PreferenceEntry;

class Preferences : public BaseClass {
    private:
        PreferenceEntry  m_preferences[MAX_NUM_PREFERENCES]; 
        int              m_num_preferences;
         
    public:
        Preferences(Logger *logger);
        virtual ~Preferences();
       
        int   numPreferences();
        char *getPreference(char *name,char *buffer,int buffer_length,char *def_value);
        int   getIntPreference(char *name,int def_value);
        bool  getBooleanPreference(char *name,bool def_value);
        
        void  fixCoordsForIOC();
        
    private:
        bool          initialize();   
         
        int           indexOfPreference(char *name);
 };

#endif // _PREFERENCES_H_