/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "PhilipsLight.h"
 #include "HTTPTransport.h"
  
 // default constructor
 PhilipsLight::PhilipsLight(int id,void *transport,Logger *logger) : BaseClass(logger,NULL) {
     this->m_id = id;
     sscanf(PL_DEFAULT_STATE,"%d",&this->m_state);
     this->m_dim = PL_DEFAULT_DIM;
     memset(this->m_url,0,PL_URL_BUFFER_LEN+1);
     memset(this->m_payload,0,PL_PAYLOAD_BUFFER_LEN+1);
     memset(this->m_response,0,PL_RESPONSE_BUFFER_LEN+1);
     this->m_transport = transport;
 }
 
 // destructor
 PhilipsLight::~PhilipsLight() {
 }
 
 // turn the light on
 void PhilipsLight::on() { this->m_state = 1; this->update(); }
 
 // turn the light off
 void PhilipsLight::off() { this->m_state = 0; this->update(); }
  
 // dim the light
 void PhilipsLight::dim(int dim) { this->m_dim = dim; this->update(); }
  
 // set the light state
 void PhilipsLight::update() {
     // create the state string
     char *str_state = "false";
     if (this->m_state == 1) str_state = "true";
     
     // make the URL
     sprintf(this->m_url,PL_URL_TEMPLATE,PL_GW_ADDRESS,this->m_id);
     
     // make the payload
     sprintf(this->m_payload,PL_ON_COMMAND_TEMPLATE,str_state,this->m_dim);
     
     // get the transport
     HTTPTransport *transport = (HTTPTransport *)this->m_transport;
     
     // initialize the respones
     memset(this->m_response,0,PL_RESPONSE_BUFFER_LEN+1);
     
     // DEBUG
     //this->logger()->log("Setting Philips light: %d payload: %s",this->m_id,this->m_payload);
     //this->logger()->log("Setting Philips light: url: %s",this->m_url);
     
     // issue the PUT
     bool success = false;
     if (transport != NULL) success = transport->httpPut(this->m_url,this->m_payload,strlen(this->m_payload),this->m_response,PL_RESPONSE_BUFFER_LEN);
     
     // DEBUG
     if (success) this->logger()->log("Philips Light: %d updated successfully",this->m_id);
     //else this->logger()->log("Philips Light: %d update FAILED.",this->m_id);
     //this->logger()->log("Philips Light: Response: %s",this->m_response);
 }