/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "mbed.h"
 
 #include "MBEDgps.h"
 
 #include "MBEDEndpoint.h"
 
 // default constructor
 MBEDgps::MBEDgps(Logger *logger,Resource *resource) : MBEDio(logger,resource) {
 }
 
 // destructor
 MBEDgps::~MBEDgps() {
 }

 // update our value
 void MBEDgps::update() {
     MBEDEndpoint *endpoint = (MBEDEndpoint *)this->logger()->getEndpoint();
     char buffer[PREFERENCE_VALUE_LEN+1];
     memset(buffer,0,PREFERENCE_VALUE_LEN+1);
     char *coords = ENDPOINT_GPS_COORDS;
     if (endpoint != NULL && endpoint->preferences() != NULL)
        coords = endpoint->preferences()->getPreference("coords",buffer,PREFERENCE_VALUE_LEN,ENDPOINT_GPS_COORDS);
     if (this->resource() != NULL && this->resource()->getValuePointer() != NULL) strcpy(this->resource()->getValuePointer(),coords); // fixed GPS for now...
 }
