/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 #include "mbed.h"
 
 // Definitions
 #include "Definitions.h"
 
 // MBED temperature sensor
 #include "LM75B.h"
 LM75B temp_sensor(TEMP_SENSOR_PIN1,TEMP_SENSOR_PIN2);

 #include "MBEDTemperature.h"
 
 // Multitech temp probe: if used, probe the LM75B once only... the multitech unit will drive future temp updates...
 #ifdef MULTITECH_TEMP_PROBE
 bool oneshot = false;
 #endif

 // default constructor
 MBEDTemperature::MBEDTemperature(Logger *logger,Resource *resource) : MBEDio(logger,resource) {
 }
 
 // destructor
 MBEDTemperature::~MBEDTemperature() {
 }

 // update our value
 void MBEDTemperature::update() {
#ifdef MULTITECH_TEMP_PROBE
     if (!oneshot) { if (this->resource() != NULL && this->resource()->getValuePointer() != NULL) sprintf(this->resource()->getValuePointer(),"%.1f",temp_sensor.read()); oneshot = true; }
#else
     if (this->resource() != NULL && this->resource()->getValuePointer() != NULL) sprintf(this->resource()->getValuePointer(),"%.1f",temp_sensor.read());
#endif
 }
