/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef _HTTP_TRANSPORT_H_
#define _HTTP_TRANSPORT_H_

// Base Class
#include "Transport.h"

// HTTP Client Library Support
#include "HTTPClient.h"

class HTTPTransport : public Transport {
    protected:
        HTTPClient *m_http;
          
    public:
        HTTPTransport(Logger *logger,void *endpoint);
        HTTPTransport(HTTPClient *http,Logger *logger,void *endpoint);
        virtual ~HTTPTransport();

        virtual void basicAuth(char *username,char *pw);
        virtual bool httpGet(char *url,char *result,int result_length,int timeout=0);
        virtual bool httpPut(char *url,char *data,int data_length,char *result,int result_length);
        virtual bool httpPost(char *url,char *data,int data_length,char *result,int result_length);
        virtual bool httpDelete(char *url,char *data,int data_length);
};

#endif // _HTTP_TRANSPORT_H_