/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef _COMMON_DEFINITIONS_H_
#define _COMMON_DEFINITIONS_H_

// maximum memory buffer chunk (including HTTPS requests)
#define MAX_BUFFER_LENGTH           256

// maximum memory buffer chunk (including HTTPS requests)
#define MAX_SMALL_BUFFER_LENGTH     256

// Error Handler Log Message Length
#define MAX_LOG_MESSAGE             MAX_BUFFER_LENGTH               // maximum size of a logging message
#define TEMP_BUFFER_LEN             128                             // working/temp buffer length

// Resource Configuration
#define RESOURCE_NAME_LEN           25                              // Resource name max length
#define RESOURCE_VALUE_LEN          33                              // Resource value max length

// Number of Resources our Endpoint has
#define NUM_RESOURCES               30                              // do not exceed this number of resources in the endpoint. currently at 25

// IOC <--> Resource Mapping
#define NUM_MAPPINGS                20                              // do not exceed this number of IOC <--> NSP resource mappings. currently at 17

// MapEntry Name length
#define MAX_NAME_LENGTH             25

// Preferences configuration
#define MAX_NUM_PREFERENCES         5                               // support a total of 5 unique preferences
#define PREFERENCE_NAME_LEN         24                              // largest preference name
#define PREFERENCE_VALUE_LEN        40                              // largest preference value

// Personality Configuration
#define NUM_PERSONALITY_INSTANCES   1                               // number of isntances of a specific personality (i.e. light) in this endpoint
#define PERSONALITY_NAME_LEN        24                              // buffer size for the personality name
#define PERSONALITY_NAME_INDEX      1                               // start index for the ID of the personality name

// Common Light Definition
#define LIGHT_DIM_STATE             "75"                            // initial dimming state of each light in this endpoint
#define LIGHT_TYPE_STRING           "Light"                         // Type of Light (string)
#define LIGHT_BLINK_WAIT_MS         1000                            // time between blinks (ms)
#define LIGHT_DEFAULT_STATE         1                               // ON by default

// Multitech probe for temperature reporting
//#define MULTITECH_TEMP_PROBE        true

// Disable local filesystem (required for Keil debugging)
//#define NO_LOCAL_FILESYSTEM     true

// Until we get HTTPS with BasicAuth working in MBED...
#define GW_IPADDRESS                "192.168.1.220"      // gateway IP address (default)
#define GW_PORT                     "8888"               // gateway port (default)

// IOC REST URL for AutoRegister
#define IOC_USERNAME                "anson"
#define IOC_PASSWORD                "savetheplanet1"

// Auto Registration with IOC on init/startup
#define AUTO_REGISTER_WITH_IOC      true                            // true - auto register, false - dont

// Personalities may have unique default light states
#ifdef LIGHT_PERSONALITY
    #undef LIGHT_DEFAULT_STATE
    #undef LIGHT_BLINK_WAIT_MS
    #define LIGHT_DEFAULT_STATE     "1"                             // ON by default
    #define LIGHT_BLINK_WAIT_MS     1000                            // time between blinks (ms)
    #if APM_LIGHT_ENABLE
        #define APM_LIGHT_PERSONALITY true 
    #endif
#endif
#ifdef COPCAR_PERSONALITY
    #undef LIGHT_DEFAULT_STATE
    #undef LIGHT_BLINK_WAIT_MS
    #define LIGHT_DEFAULT_STATE     "0"                             // OFF by default
    #define LIGHT_BLINK_WAIT_MS     400                             // time between blinks (ms)
#endif

// Main Loop
#define MAIN_LOOP_SLEEP             250                             // sleep time (ms) between main loop iterations

// LED Blink Time
#define BLINK_TIME                  100                             // LED blink times

// External Linkage Resource
#define EXTERNAL_LINKAGE_RESOURCE   "/dev/addldata"                 // resource containing IOC linkage ID
#define EXTERNAL_LINKAGE_UNSET      "id:0"                          // IOC linkage not set

// Salesforce Case generation (Status Report)
#define SF_STATUS_REPORTING         true                           // true - enable, false - disable

// ----------------- Status Reporting TUNABLES -----------------  
 
// 3 Reports for RFID-tag based support/repair conditions
 #define FIRST_REPORT_RFID         7550993
 #define FIRST_REPORT_NAME         "Tech 49"
 #define FIRST_REPORT_DESCRIPTION  "Light Out"
 #define FIRST_REPORT_CONDITION    "Investigating Issue"
 #define FIRST_REPORT_LATITUDE     "37.404120"
 #define FIRST_REPORT_LONGITUDE    "-121.973195"
 
 #define SECOND_REPORT_RFID        7567145
 #define SECOND_REPORT_NAME        "Tech 49"
 #define SECOND_REPORT_DESCRIPTION "Light Out"
 #define SECOND_REPORT_CONDITION   "Resolved - lightbulb burned out"
 #define SECOND_REPORT_LATITUDE    "37.404120"
 #define SECOND_REPORT_LONGITUDE   "-121.973195"
 
 #define THIRD_REPORT_RFID         7559217
 #define THIRD_REPORT_NAME         "Tech 49"
 #define THIRD_REPORT_DESCRIPTION  "Light Out"
 #define THIRD_REPORT_CONDITION    "Unresolved - escalate"
 #define THIRD_REPORT_LATITUDE     "37.404120"
 #define THIRD_REPORT_LONGITUDE    "-121.973195"
 
// ----------------- Status Reporting TUNABLES ----------------- 
 
// DF2014 CaseGenerator Relay for mbed - ties into the Salesforce APEX host for case generation
#define DF_CASE_GEN_URL           "https://df2014-arm-developer-edition.na15.force.com/services/apexrest/CaseService"

// Buffer length for HTTPS requests
#define BUFFER_LENGTH              256

// Tunables for ReportDB
 #define DB_MAX_NAME_LENGTH        64
 #define DB_MAX_DESCRIPTION_LENGTH 128
 #define DB_MAX_CONDITION_LENGTH   128
 #define DB_MAX_LATLONG_LENGTH     32
 #define DB_MAX_NUM_REPORTS        3
 
 // convenience definitions for ReportDB... 3 RFID tags/station  
 #define FIRST_REPORT              0
 #define SECOND_REPORT             1
 #define THIRD_REPORT              2

// Philips Light Support
#define PL_LIGHT_ID_DOUG            1                               // Dougs Light
#define PL_LIGHT_ID_BILL            2                               // Bills Light
#define PL_LIGHT_ID_KERRY           3                               // Kerrys Light
#define PL_GW_ADDRESS               "192.168.1.178"                 // Philips Gateway in IOT lab (Austin)
#define PL_DEFAULT_STATE            LIGHT_DEFAULT_STATE             // on
#define PL_DEFAULT_DIM              11                              // dim value
#define PL_URL_BUFFER_LEN           128
#define PL_PAYLOAD_BUFFER_LEN       128
#define PL_RESPONSE_BUFFER_LEN      128
#define PL_URL_TEMPLATE             "http://%s/api/newdeveloper/lights/%d/state"  
#define PL_ON_COMMAND_TEMPLATE      "{ \"on\":%s, \"sat\":211, \"bri\":%d, \"hue\":13122 } "

#ifndef CELLULAR_NETWORK
    // Error Handler - use mutexes?
    #define EH_USE_MUTEXES              true                            // true - yes, undef - no
    
    // Network - use mutexes?
    #define NETWORK_MUTEX               true                            // true - yes, undef - no
    
    // Has Threads?
    #define ENABLE_THREADS              true                            // true - yes, undef - no
#endif

// Platform specific customizations
#ifdef _ENDPOINT_UBLOX_PLATFORM
    #define PLATFORM_STRING         "U-Blox MBED"                   // platform string
    #define EXT_LED_PIN             D3                              // pin to use for external LED cathode, use D6 for speaker 
    #define EXT_LED_PIN_COPCAR      D10                             // pin to use for external LED cathode (copcar personality only) 
    #define BATTERY_POT_PIN         A0                              // pin for the battery POT
    #define VOLTAGE_POT_PIN         A1                              // pin for the voltage POT
    #define TEMP_SENSOR_PIN1        P0_0                            // pin for temp sensor
    #define TEMP_SENSOR_PIN2        P0_1                            // pin for temp sensor
    #define RFID_TX_PIN             D1                              // pin for RFID sensor
    #define RFID_RX_PIN             D0                              // pin for RFID sensor
    #define TEMP_PIN                A3                              // pin for TMP36 temp sensor
#endif

#ifdef _ENDPOINT_NXP_PLATFORM
    #define PLATFORM_STRING         "NXP MBED"                      // platform string
    #define EXT_LED_PIN             p21                             // pin to use for external LED cathode 
    #define EXT_LED_PIN_COPCAR      p22                             // pin to use for external LED cathode (copcar personality only)
    #define BATTERY_POT_PIN         p20                             // pin for the battery POT
    #define VOLTAGE_POT_PIN         p19                             // pin for the voltage POT
    #define TEMP_SENSOR_PIN1        p28                             // pin for temp sensor
    #define TEMP_SENSOR_PIN2        p27                             // pin for temp sensor
    #define RFID_TX_PIN             p13                             // pin for RFID sensor
    #define RFID_RX_PIN             p14                             // pin for RFID sensor
    #define TEMP_PIN                p15                             // pin for TMP36 temp sensor
#endif

#ifdef _ENDPOINT_FREEDOM_PLATFORM   
    #define PLATFORM_STRING         "Freescale MBED"                // platform string
    #define EXT_LED_PIN             p21                             // pin to use for external LED cathode
    #define EXT_LED_PIN_COPCAR      p22                             // pin to use for external LED cathode (copcar personality only)
    #define BATTERY_POT_PIN         p20                             // pin for the battery POT 
    #define VOLTAGE_POT_PIN         p19                             // pin for the voltage POT
    #define TEMP_SENSOR_PIN1        p28                             // pin for temp sensor
    #define TEMP_SENSOR_PIN2        p27                             // pin for temp sensor
    #define RFID_TX_PIN             D1                              // pin for RFID sensor
    #define RFID_RX_PIN             D0                              // pin for RFID sensor
    #define TEMP_PIN                A3                              // pin for TMP36 temp sensor
#endif

#endif // _COMMON_DEFINITIONS_H_