/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 // base class support
 #include "BaseClass.h"
 
 // default constructor
 BaseClass::BaseClass(Logger *logger,void *endpoint) {
     this->m_logger = logger;
     this->m_endpoint = endpoint;
 }
 
 // default destructor
 BaseClass::~BaseClass() {
 }
 
 // Logger accessor
 Logger *BaseClass::logger() { return this->m_logger; }
 
 // Endpoint accessor
 void *BaseClass::getEndpoint() { return this->m_endpoint; }
 void BaseClass::setEndpoint(void *endpoint) { this->m_endpoint = endpoint; }
 
 // min function
 int BaseClass::min(int value1,int value2) {
    if (value1 < value2) return value1;
    return value2;
 }