/**
 * @file    LocationResource.h
 * @brief   mbed CoAP Endpoint Location resource supporting CoAP GET
 * @author  Doug Anson
 * @version 1.0
 * @see
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __LOCATION_RESOURCE_H__
#define __LOCATION_RESOURCE_H__

// Base class
#include "DynamicResource.h"

// We have a static location by default - Moscone West - 37.783879,-122.4012538
#define MY_LATITUDE     37.783879
#define MY_LONGITUDE    -122.4012538
#define MY_ALTITUDE     30.0
#define MY_SPEED        0.0

// Maximum Location JSON Length : {"latitude":XXX.YYYYYY, "longitude":XXX.YYYYYY, "msl":XXXXXX, "speed":XXXXXX}
#define LOCATION_JSON_LENGTH  256
char __location_json[LOCATION_JSON_LENGTH+1];

/** LocationResource class
 */
class LocationResource : public DynamicResource
{
public:
    /**
    Default constructor
    @param logger input logger instance for this resource
    @param name input the Location resource name
    @param observable input the resource is Observable (default: FALSE)
    */
    LocationResource(const Logger *logger,const char *name,const bool observable = false) : DynamicResource(logger,name,"Location",SN_GRS_GET_ALLOWED,observable) {
        memset(__location_json,0,LOCATION_JSON_LENGTH+1);
    }

    /**
    Get the value of the Location sensor
    @returns string containing the location value
    */
    virtual string get() {
        memset(__location_json,0,LOCATION_JSON_LENGTH);
        sprintf(__location_json,"{\"latitude\":%.6f,\"longitude\":%.6f,\"msl\":%.1f,\"speed\":%.1f}",
                    MY_LATITUDE,
                    MY_LONGITUDE,
                    MY_ALTITUDE,        // in meters
                    MY_SPEED);          // in meters/second
        return string(__location_json);
    }
};

#endif // __LOCATION_RESOURCE_H__