/**
 * @file    HeartrateResource.h
 * @brief   mbed CoAP Endpoint Heartrate resource (Grove Earbud) supporting CoAP GET and PUT
 * @author  Doug Anson
 * @version 1.0
 * @see
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __HEARTRATE_RESOURCE_H__
#define __HEARTRATE_RESOURCE_H__

// Base class
#include "DynamicResource.h"

// which Nordic board?
#ifdef TARGET_NRF51_DK
    #define ENDPOINT_INTERRUPT_PIN P0_14
#endif
#ifdef TARGET_NRF51_DONGLE
    #define ENDPOINT_INTERRUPT_PIN P0_15
#endif
#ifdef TARGET_NRF51_MKIT
    #define ENDPOINT_INTERRUPT_PIN P0
#endif
#ifdef TARGET_K64F
    #define ENDPOINT_INTERRUPT_PIN D2
#endif

// Grove Earbud Sensor
#include "GroveEarbudSensor.h"
//extern RawSerial pc;                                    // declared in main.cpp for logger... just reference here...     
GroveEarbudSensor __earbud(ENDPOINT_INTERRUPT_PIN,&pc);

// HRM sensor value
static char __hrm[10];

// forward declaration
extern void __hrm_callback(float value,void *instance);

/** HeartrateResource class
 */
class HeartrateResource : public DynamicResource
{

public:
    /**
    Default constructor
    @param logger input logger instance for this resource
    @param name input the Light resource name
    @param observable input the resource is Observable (default: FALSE)
    */
    HeartrateResource(const Logger *logger,const char *name,const bool observable = false) : DynamicResource(logger,name,"Heartrate",SN_GRS_GET_ALLOWED,observable) {
        // init...
        memset(__hrm,0,10);
        sprintf(__hrm,"0.0");
        
        // finish setup of the earbud sensor
        __earbud.registerCallback(&__hrm_callback,this);
        
        // this resource implements its own observation handler...
        this->m_implements_observation = true;
    }

    /**
    Get the value of the Heartrate sensor
    @returns string containing the heartrate in bpm
    */
    virtual string get() {
       return string(__hrm);
    }
};

// Heartrate callback (Earbud)
void __hrm_callback(float heartrate,void *data) {
    memset(__hrm,0,10);
    sprintf(__hrm,"%.1f",heartrate);
    
    // observation handler implementation
    if (data != NULL) {
        HeartrateResource *res = (HeartrateResource *)data;
        if (res->isObservable()) {
            res->observe();
        }
    }
}

#endif // __HEARTRATE_RESOURCE_H__